/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vonage.client.conversations.AudioRecordEventBody;
import com.vonage.client.conversations.Event;
import com.vonage.client.conversations.EventType;
import com.vonage.client.conversations.EventWithBody;
import com.vonage.client.voice.TextToSpeechLanguage;

public final class AudioRecordEvent
extends EventWithBody<AudioRecordEventBody> {
    AudioRecordEvent() {
    }

    private AudioRecordEvent(Builder builder) {
        super(builder);
        this.body = new AudioRecordEventBody(builder);
    }

    @JsonIgnore
    public TextToSpeechLanguage getLanguage() {
        return this.body != null ? (((AudioRecordEventBody)this.body).transcription != null ? ((AudioRecordEventBody)this.body).transcription.language : null) : null;
    }

    @JsonIgnore
    public Boolean getSentimentAnalysis() {
        return this.body != null ? (((AudioRecordEventBody)this.body).transcription != null ? ((AudioRecordEventBody)this.body).transcription.sentimentAnalysis : null) : null;
    }

    @JsonIgnore
    public String getFormat() {
        return this.body != null ? ((AudioRecordEventBody)this.body).format : null;
    }

    @JsonIgnore
    public Integer getValidity() {
        return this.body != null ? ((AudioRecordEventBody)this.body).validity : null;
    }

    @JsonIgnore
    public Integer getChannels() {
        return this.body != null ? ((AudioRecordEventBody)this.body).channels : null;
    }

    @JsonIgnore
    public Boolean getStreamed() {
        return this.body != null ? ((AudioRecordEventBody)this.body).streamed : null;
    }

    @JsonIgnore
    public Boolean getSplit() {
        return this.body != null ? ((AudioRecordEventBody)this.body).split : null;
    }

    @JsonIgnore
    public Boolean getMultitrack() {
        return this.body != null ? ((AudioRecordEventBody)this.body).multitrack : null;
    }

    @JsonIgnore
    public Boolean getDetectSpeech() {
        return this.body != null ? ((AudioRecordEventBody)this.body).detectSpeech : null;
    }

    @JsonIgnore
    public Boolean getBeepStart() {
        return this.body != null ? ((AudioRecordEventBody)this.body).beepStart : null;
    }

    @JsonIgnore
    public Boolean getBeepStop() {
        return this.body != null ? ((AudioRecordEventBody)this.body).beepStop : null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends Event.Builder<AudioRecordEvent, Builder> {
        String format;
        Integer validity;
        Integer channels;
        Boolean streamed;
        Boolean split;
        Boolean multitrack;
        Boolean detectSpeech;
        Boolean beepStart;
        Boolean beepStop;
        Boolean sentimentAnalysis;
        TextToSpeechLanguage language;

        Builder() {
            super(EventType.AUDIO_RECORD);
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder validity(int validity) {
            this.validity = validity;
            return this;
        }

        public Builder channels(int channels) {
            this.channels = channels;
            return this;
        }

        public Builder streamed(boolean streamed) {
            this.streamed = streamed;
            return this;
        }

        public Builder split(boolean split) {
            this.split = split;
            return this;
        }

        public Builder multitrack(boolean multitrack) {
            this.multitrack = multitrack;
            return this;
        }

        public Builder detectSpeech(boolean detectSpeech) {
            this.detectSpeech = detectSpeech;
            return this;
        }

        public Builder beepStart(boolean beepStart) {
            this.beepStart = beepStart;
            return this;
        }

        public Builder beepStop(boolean beepStop) {
            this.beepStop = beepStop;
            return this;
        }

        public Builder sentimentAnalysis(boolean sentimentAnalysis) {
            this.sentimentAnalysis = sentimentAnalysis;
            return this;
        }

        public Builder language(TextToSpeechLanguage language) {
            this.language = language;
            return this;
        }

        @Override
        public AudioRecordEvent build() {
            return new AudioRecordEvent(this);
        }
    }
}

