/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.auth.hashutils;

import com.vonage.client.auth.hashutils.AbstractHasher;
import com.vonage.client.auth.hashutils.HashType;
import com.vonage.client.auth.hashutils.HmacMd5Hasher;
import com.vonage.client.auth.hashutils.HmacSha1Hasher;
import com.vonage.client.auth.hashutils.HmacSha256Hasher;
import com.vonage.client.auth.hashutils.HmacSha512Hasher;
import com.vonage.client.auth.hashutils.Md5Hasher;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public final class HashUtil {
    private static final Map<HashType, AbstractHasher> HASH_TYPES = new HashMap<HashType, AbstractHasher>(8);

    private HashUtil() {
    }

    public static String calculate(String input, HashType hashType) throws NoSuchAlgorithmException, InvalidKeyException {
        return HASH_TYPES.get((Object)hashType).calculate(input);
    }

    public static String calculate(String input, String secretKey, HashType hashType) throws NoSuchAlgorithmException, InvalidKeyException {
        return HASH_TYPES.get((Object)hashType).calculate(input, secretKey);
    }

    static {
        HASH_TYPES.put(HashType.MD5, new Md5Hasher());
        HASH_TYPES.put(HashType.HMAC_SHA1, new HmacSha1Hasher());
        HASH_TYPES.put(HashType.HMAC_MD5, new HmacMd5Hasher());
        HASH_TYPES.put(HashType.HMAC_SHA256, new HmacSha256Hasher());
        HASH_TYPES.put(HashType.HMAC_SHA512, new HmacSha512Hasher());
    }
}

