/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.auth.camara;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.auth.camara.AuthRequest;
import com.vonage.client.auth.camara.FraudPreventionDetectionScope;
import java.net.URI;
import java.util.Objects;
import java.util.UUID;

public class FrontendAuthRequest
extends AuthRequest {
    public FrontendAuthRequest(String msisdn, URI redirectUrl, UUID applicationId, String state) {
        super(msisdn, FraudPreventionDetectionScope.NUMBER_VERIFICATION_VERIFY_READ);
        this.params.put("client_id", Objects.requireNonNull(applicationId, "Application ID is required.").toString());
        this.params.put("redirect_uri", Objects.requireNonNull(redirectUrl, "Redirect URL is required.").toString());
        this.params.put("response_type", "code");
        if (state != null) {
            this.params.put("state", state);
        }
    }

    public URI buildOidcUrl() {
        return DynamicEndpoint.buildUri("https://oidc.idp.vonage.com/oauth2/auth", this.makeParams());
    }
}

