/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.auth;

import com.vonage.client.auth.ApiKeyAuthMethod;
import com.vonage.client.auth.ApiKeyQueryParamsAuthMethod;
import com.vonage.client.auth.BasicAuthMethod;
import com.vonage.client.auth.QueryParamsAuthMethod;
import java.util.Base64;

public class ApiKeyHeaderAuthMethod
extends BasicAuthMethod
implements ApiKeyAuthMethod {
    private static final int SORT_KEY = 40;
    private final String apiKey;
    private final String apiSecret;

    public ApiKeyHeaderAuthMethod(String apiKey, String apiSecret) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
    }

    @Override
    public String getApiKey() {
        return this.apiKey;
    }

    QueryParamsAuthMethod asQueryParams() {
        return new ApiKeyQueryParamsAuthMethod(this.apiKey, this.apiSecret);
    }

    @Override
    protected String getBasicToken() {
        return Base64.getEncoder().encodeToString((this.apiKey + ":" + this.apiSecret).getBytes());
    }

    @Override
    public int getSortKey() {
        return 40;
    }
}

