/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.application.capabilities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.application.capabilities.Capability;
import com.vonage.client.application.capabilities.Region;
import com.vonage.client.application.capabilities.Webhook;

public final class Voice
extends Capability {
    private Region region;
    private Boolean signedCallbacks;
    private Integer conversationsTtl;
    private Integer legPersistenceTime;

    private Voice() {
    }

    private Voice(Builder builder) {
        super(builder);
        this.region = builder.region;
        this.signedCallbacks = builder.signedCallbacks;
        this.conversationsTtl = builder.conversationsTtl;
        if (this.conversationsTtl != null && (this.conversationsTtl < 0 || this.conversationsTtl > 744)) {
            throw new IllegalArgumentException("Conversations TTL cannot be negative.");
        }
        this.legPersistenceTime = builder.legPersistenceTime;
        if (this.legPersistenceTime != null && (this.legPersistenceTime < 0 || this.legPersistenceTime > 31)) {
            throw new IllegalArgumentException("Leg persistence time must be positive and less than 31 days.");
        }
    }

    @JsonProperty(value="region")
    public Region getRegion() {
        return this.region;
    }

    @JsonProperty(value="signed_callbacks")
    public Boolean getSignedCallbacks() {
        return this.signedCallbacks;
    }

    @JsonProperty(value="conversations_ttl")
    public Integer getConversationsTtl() {
        return this.conversationsTtl;
    }

    @JsonProperty(value="leg_persistence_time")
    public Integer getLegPersistenceTime() {
        return this.legPersistenceTime;
    }

    @Override
    public Capability.Type getType() {
        return Capability.Type.VOICE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Capability.Builder<Voice, Builder> {
        private Region region;
        private Boolean signedCallbacks;
        private Integer conversationsTtl;
        private Integer legPersistenceTime;

        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        public Builder signedCallbacks(boolean signed) {
            this.signedCallbacks = signed;
            return this;
        }

        public Builder conversationsTtl(int ttl) {
            this.conversationsTtl = ttl;
            return this;
        }

        public Builder legPersistenceTime(int legPersistenceTime) {
            this.legPersistenceTime = legPersistenceTime;
            return this;
        }

        public Builder answer(Webhook webhook) {
            return (Builder)this.webhook(Webhook.Type.ANSWER, webhook);
        }

        public Builder fallbackAnswer(Webhook webhook) {
            return (Builder)this.webhook(Webhook.Type.FALLBACK_ANSWER, webhook);
        }

        public Builder event(Webhook webhook) {
            return (Builder)this.webhook(Webhook.Type.EVENT, webhook);
        }

        @Override
        public Voice build() {
            return new Voice(this);
        }
    }
}

