/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.application.capabilities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.application.capabilities.Webhook;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public abstract class Capability
extends JsonableBaseObject {
    protected Map<Webhook.Type, Webhook> webhooks;

    protected Capability() {
    }

    protected Capability(Builder<?, ?> builder) {
        this.webhooks = builder.webhooks;
    }

    @JsonIgnore
    public abstract Type getType();

    @JsonProperty(value="webhooks")
    public Map<Webhook.Type, Webhook> getWebhooks() {
        return this.webhooks;
    }

    protected static abstract class Builder<C extends Capability, B extends Builder<C, B>> {
        Map<Webhook.Type, Webhook> webhooks;

        protected Builder() {
        }

        final B webhook(Webhook.Type type, Webhook webhook) {
            if (this.webhooks == null) {
                this.webhooks = new LinkedHashMap<Webhook.Type, Webhook>();
            }
            if (webhook != null) {
                this.webhooks.put(type, webhook);
            } else {
                this.webhooks.remove((Object)type);
                if (this.webhooks.isEmpty()) {
                    this.webhooks = null;
                }
            }
            return (B)this;
        }

        public abstract C build();
    }

    public static enum Type {
        VOICE,
        RTC,
        MESSAGES,
        VBC,
        VERIFY,
        NETWORK;

    }
}

