/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.vonage.client.Jsonable;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageUnexpectedException;
import java.net.URI;
import java.util.List;
import java.util.Objects;

public class VonageApiResponseException
extends VonageClientException
implements Jsonable {
    protected URI type;
    protected String title;
    protected String detail;
    protected String instance;
    protected String code;
    protected String errorCodeLabel;
    protected String errorCode;
    protected List<?> errors;
    protected List<?> invalidParameters;
    @JsonIgnore
    protected int statusCode;

    protected VonageApiResponseException() {
    }

    protected VonageApiResponseException(String message) {
        super(message);
    }

    protected VonageApiResponseException(String message, Throwable cause) {
        super(message, cause);
    }

    protected VonageApiResponseException(Throwable cause) {
        super(cause);
    }

    @JsonIgnore
    protected void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    @JsonSetter(value="error-code")
    private void setErrorCode(String errorCode) {
        if (errorCode != null && !errorCode.trim().isEmpty()) {
            this.statusCode = Integer.parseInt(errorCode);
        }
    }

    @JsonProperty(value="error-code-label")
    public String getErrorCodeLabel() {
        return this.errorCodeLabel;
    }

    @JsonProperty(value="type")
    public URI getType() {
        return this.type;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="detail")
    public String getDetail() {
        return this.detail;
    }

    @JsonProperty(value="instance")
    public String getInstance() {
        return this.instance;
    }

    @JsonProperty(value="errors")
    public List<?> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="invalid_parameters")
    public List<?> getInvalidParameters() {
        return this.invalidParameters;
    }

    @JsonProperty(value="code")
    public String getCode() {
        return this.code;
    }

    @JsonIgnore
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public String getMessage() {
        if (this.statusCode > 0 && this.title != null) {
            String message = this.statusCode + " (" + this.title + ")";
            if (this.detail != null) {
                message = message + ": " + this.detail;
            }
            return message;
        }
        return super.getMessage();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VonageApiResponseException response = (VonageApiResponseException)o;
        return this.statusCode == response.statusCode && Objects.equals(this.type, response.type) && Objects.equals(this.title, response.title) && Objects.equals(this.detail, response.detail) && Objects.equals(this.instance, response.instance);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.title, this.detail, this.instance, this.statusCode);
    }

    @Override
    public String toJson() {
        try {
            return Jsonable.createDefaultObjectMapper().setAnnotationIntrospector((AnnotationIntrospector)new IgnoreInheritedIntrospector()).writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new VonageUnexpectedException("Failed to produce JSON from " + this.getClass().getSimpleName(), e);
        }
    }

    protected static <E extends VonageApiResponseException> E fromJson(Class<E> clazz, String json) {
        if (json == null || json.length() < 2) {
            try {
                return (E)((VonageApiResponseException)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception ex) {
                throw new VonageUnexpectedException(ex);
            }
        }
        return (E)((VonageApiResponseException)Jsonable.fromJson(json, clazz));
    }

    private static class IgnoreInheritedIntrospector
    extends JacksonAnnotationIntrospector {
        private IgnoreInheritedIntrospector() {
        }

        public boolean hasIgnoreMarker(AnnotatedMember m) {
            return m.getDeclaringClass().equals(Throwable.class) || super.hasIgnoreMarker(m);
        }
    }
}

