/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum RecordingFormat {
    MP3,
    WAV,
    OGG,
    UNKNOWN;

    private static final Map<String, RecordingFormat> RECORDING_FORMAT_INDEX;

    @JsonValue
    public String toString() {
        return this.name().toLowerCase();
    }

    @JsonCreator
    public static RecordingFormat fromString(String name) {
        RecordingFormat foundRecordingFormat = RECORDING_FORMAT_INDEX.get(name.toUpperCase());
        return foundRecordingFormat != null ? foundRecordingFormat : UNKNOWN;
    }

    static {
        RECORDING_FORMAT_INDEX = new HashMap<String, RecordingFormat>();
        for (RecordingFormat recordingFormat : RecordingFormat.values()) {
            RECORDING_FORMAT_INDEX.put(recordingFormat.name(), recordingFormat);
        }
    }
}

