/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageClientException;
import com.vonage.client.voice.Call;
import com.vonage.client.voice.CallEvent;
import com.vonage.client.voice.CallInfo;
import com.vonage.client.voice.CallInfoPage;
import com.vonage.client.voice.CallModifier;
import com.vonage.client.voice.CallsFilter;
import com.vonage.client.voice.CreateCallMethod;
import com.vonage.client.voice.ListCallsMethod;
import com.vonage.client.voice.ModifyCallMethod;
import com.vonage.client.voice.ModifyCallResponse;
import com.vonage.client.voice.ReadCallMethod;

class CallsEndpoint {
    private final CreateCallMethod createCall;
    private final ReadCallMethod readCall;
    private final ListCallsMethod listCalls;
    private final ModifyCallMethod modifyCall;

    CallsEndpoint(HttpWrapper httpWrapper) {
        this.createCall = new CreateCallMethod(httpWrapper);
        this.readCall = new ReadCallMethod(httpWrapper);
        this.listCalls = new ListCallsMethod(httpWrapper);
        this.modifyCall = new ModifyCallMethod(httpWrapper);
    }

    CallEvent post(Call callRequest) throws VonageClientException {
        return (CallEvent)this.createCall.execute(callRequest);
    }

    CallInfoPage get(CallsFilter filter) throws VonageClientException {
        return (CallInfoPage)this.listCalls.execute(filter);
    }

    CallInfo get(String uuid) throws VonageClientException {
        return (CallInfo)this.readCall.execute(uuid);
    }

    ModifyCallResponse put(CallModifier modifier) throws VonageClientException {
        return (ModifyCallResponse)this.modifyCall.execute(modifier);
    }
}

