/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.numbers;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageClientException;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.numbers.ListNumbersFilter;
import com.vonage.client.numbers.ListNumbersResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

class ListNumbersEndpoint
extends AbstractMethod<ListNumbersFilter, ListNumbersResponse> {
    private static final String PATH = "/account/numbers";
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};

    ListNumbersEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(ListNumbersFilter request) throws UnsupportedEncodingException {
        RequestBuilder requestBuilder = RequestBuilder.get().setUri(this.httpWrapper.getHttpConfig().getRestBaseUri() + PATH);
        request.addParams(requestBuilder);
        return requestBuilder;
    }

    @Override
    public ListNumbersResponse parseResponse(HttpResponse response) throws IOException {
        String json = new BasicResponseHandler().handleResponse(response);
        return ListNumbersResponse.fromJson(json);
    }

    ListNumbersResponse listNumbers(ListNumbersFilter request) throws VonageClientException {
        return (ListNumbersResponse)this.execute(request);
    }
}

