/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.insight;

import com.vonage.client.insight.BaseInsightRequest;

public class AdvancedInsightRequest
extends BaseInsightRequest {
    private boolean async;
    private String callback;

    private AdvancedInsightRequest(Builder builder) {
        this.number = builder.number;
        this.country = builder.country;
        this.cnam = builder.cnam;
        this.ipAddress = builder.ipAddress;
        this.async = builder.async;
        this.callback = builder.callback;
    }

    public static Builder builder(String number) {
        return new Builder(number);
    }

    public Boolean getCnam() {
        return this.cnam;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public boolean isAsync() {
        return this.async;
    }

    public String getCallback() {
        return this.callback;
    }

    public static AdvancedInsightRequest withNumber(String number) {
        return new Builder(number).build();
    }

    public static AdvancedInsightRequest withNumberAndCountry(String number, String country) {
        return new Builder(number).country(country).build();
    }

    public static class Builder {
        protected String number;
        protected String country;
        protected Boolean cnam;
        protected String ipAddress;
        protected boolean async;
        protected String callback;

        public Builder(String number) {
            this.number = number;
        }

        public Builder number(String number) {
            this.number = number;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder cnam(Boolean cnam) {
            this.cnam = cnam;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder async(boolean async) {
            this.async = async;
            return this;
        }

        public Builder callback(String url) {
            this.callback = url;
            return this;
        }

        public AdvancedInsightRequest build() {
            if (this.async && (this.callback == null || this.callback.isEmpty())) {
                throw new IllegalStateException("You must define a callback url when using asyncronous insights.");
            }
            return new AdvancedInsightRequest(this);
        }
    }
}

