/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.auth;

import com.nexmo.jwt.Jwt;
import com.vonage.client.auth.AbstractAuthMethod;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.http.client.methods.RequestBuilder;

public class JWTAuthMethod
extends AbstractAuthMethod {
    private static final int SORT_KEY = 10;
    private Jwt jwt;

    public JWTAuthMethod(String applicationId, byte[] privateKey) {
        this.jwt = Jwt.builder().applicationId(applicationId).privateKeyContents(new String(privateKey)).build();
    }

    public JWTAuthMethod(String applicationId, Path path) throws IOException {
        this(applicationId, Files.readAllBytes(path));
    }

    public String generateToken() {
        return this.jwt.generate();
    }

    @Override
    public RequestBuilder apply(RequestBuilder request) {
        String token = this.jwt.generate();
        request.setHeader("Authorization", "Bearer " + token);
        return request;
    }

    @Override
    public int getSortKey() {
        return 10;
    }
}

