/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.account;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageBadRequestException;
import com.vonage.client.VonageClientException;
import com.vonage.client.account.CreateSecretRequest;
import com.vonage.client.account.SecretResponse;
import com.vonage.client.auth.SignatureAuthMethod;
import com.vonage.client.auth.TokenAuthMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.util.EntityUtils;

class CreateSecretMethod
extends AbstractMethod<CreateSecretRequest, SecretResponse> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{SignatureAuthMethod.class, TokenAuthMethod.class};
    private static final String PATH = "/accounts/%s/secrets";

    CreateSecretMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(CreateSecretRequest createSecretRequest) throws UnsupportedEncodingException {
        if (createSecretRequest.getApiKey() == null) {
            throw new IllegalArgumentException("API key is required.");
        }
        if (createSecretRequest.getSecret() == null) {
            throw new IllegalArgumentException("Secret is required.");
        }
        String uri = String.format(this.httpWrapper.getHttpConfig().getApiBaseUri() + PATH, createSecretRequest.getApiKey());
        return RequestBuilder.post((String)uri).setEntity((HttpEntity)new StringEntity(createSecretRequest.toJson(), ContentType.APPLICATION_JSON));
    }

    @Override
    public SecretResponse parseResponse(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() != 201) {
            throw new VonageBadRequestException(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        return SecretResponse.fromJson(new BasicResponseHandler().handleResponse(response));
    }

    @Override
    protected RequestBuilder applyAuth(RequestBuilder request) throws VonageClientException {
        return this.getAuthMethod(this.getAcceptableAuthMethods()).applyAsBasicAuth(request);
    }
}

