/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.model.response;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.apache.http.Header;

public class RawResponse {
    private byte[] data;
    private int code;
    private Exception exception;
    private Header[] headers;
    private int httpCode;

    public RawResponse(byte[] data, int code, Exception e) {
        this.data = data;
        this.code = code;
        this.exception = e;
    }

    public RawResponse(byte[] data, int code, Exception exception, Header[] headers) {
        this.data = data;
        this.code = code;
        this.exception = exception;
        this.headers = headers;
    }

    public RawResponse(byte[] data, int code, Exception exception, Header[] headers, int httpCode) {
        this.data = data;
        this.code = code;
        this.exception = exception;
        this.headers = headers;
        this.httpCode = httpCode;
    }

    public String getFirstHeader(String key) {
        if (key != null && this.headers != null) {
            for (Header header : this.headers) {
                if (!header.getName().equalsIgnoreCase(key)) continue;
                return header.getValue();
            }
        }
        return null;
    }

    public String getVerboseExceptionMessage() {
        if (this.getException() == null) {
            return null;
        }
        StringBuilder msg = new StringBuilder();
        msg.append(this.getException().getMessage()).append(":");
        if (this.getHeaders() != null) {
            for (Header header : this.getHeaders()) {
                if (header == null) continue;
                msg.append("Header name is ").append(header.getName()).append(", value is ").append(header.getValue()).append(System.lineSeparator());
            }
        }
        msg.append("http code is ").append(this.getHttpCode());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.getException().printStackTrace(pw);
        msg.append(System.lineSeparator()).append(sw);
        return msg.toString();
    }

    public byte[] getData() {
        return this.data;
    }

    public int getCode() {
        return this.code;
    }

    public Exception getException() {
        return this.exception;
    }

    public Header[] getHeaders() {
        return this.headers;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public void setHeaders(Header[] headers) {
        this.headers = headers;
    }

    public void setHttpCode(int httpCode) {
        this.httpCode = httpCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawResponse)) {
            return false;
        }
        RawResponse other = (RawResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        if (this.getHttpCode() != other.getHttpCode()) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        Exception this$exception = this.getException();
        Exception other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
            return false;
        }
        return Arrays.deepEquals(this.getHeaders(), other.getHeaders());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        result = result * 59 + this.getHttpCode();
        result = result * 59 + Arrays.hashCode(this.getData());
        Exception $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getHeaders());
        return result;
    }

    public String toString() {
        return "RawResponse(data=" + Arrays.toString(this.getData()) + ", code=" + this.getCode() + ", exception=" + this.getException() + ", headers=" + Arrays.deepToString(this.getHeaders()) + ", httpCode=" + this.getHttpCode() + ")";
    }
}

