/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.model.beans;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;

public class ReUseFileInputStream
extends InputStream {
    private File file = null;
    private FileInputStream fis = null;
    private FileChannel fileChannel = null;
    private long markPos = 0L;

    public ReUseFileInputStream(File file) throws IOException {
        this(new FileInputStream(file), file);
    }

    public ReUseFileInputStream(FileInputStream fis) throws IOException {
        this(fis, null);
    }

    public ReUseFileInputStream(FileInputStream fis, File file) throws IOException {
        this.file = file;
        this.fis = fis;
        this.fileChannel = fis.getChannel();
        this.markPos = this.fileChannel.position();
    }

    @Override
    public void reset() throws IOException {
        this.fileChannel.position(this.markPos);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.markPos = this.fileChannel.position();
        }
        catch (IOException var3) {
            throw new RuntimeException("Failed to mark file position", var3);
        }
    }

    @Override
    public int available() throws IOException {
        return this.fis.available();
    }

    @Override
    public void close() throws IOException {
        this.fis.close();
    }

    @Override
    public int read() throws IOException {
        return this.fis.read();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.fis.skip(n);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.fis.read(b, off, len);
    }

    public InputStream getWrappedInputStream() {
        return this.fis;
    }

    public File getFile() {
        return this.file;
    }
}

