/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.volcengine.tos.TosClientException;
import com.volcengine.tos.TosException;
import com.volcengine.tos.TosServerException;
import com.volcengine.tos.comm.MimeType;
import com.volcengine.tos.comm.event.DataTransferListener;
import com.volcengine.tos.comm.ratelimit.RateLimiter;
import com.volcengine.tos.internal.RequestBuilder;
import com.volcengine.tos.internal.RequestHandler;
import com.volcengine.tos.internal.ServerExceptionJson;
import com.volcengine.tos.internal.TosMarshalResult;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.TosRequestFactory;
import com.volcengine.tos.internal.TosResponse;
import com.volcengine.tos.internal.Transport;
import com.volcengine.tos.internal.model.CRC64Checksum;
import com.volcengine.tos.internal.model.CheckCrc64AutoInputStream;
import com.volcengine.tos.internal.model.CreateMultipartUploadOutputJson;
import com.volcengine.tos.internal.model.SimpleDataTransferListenInputStream;
import com.volcengine.tos.internal.model.UploadPartCopyOutputJson;
import com.volcengine.tos.internal.util.CRC64Utils;
import com.volcengine.tos.internal.util.DateConverter;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.PayloadConverter;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import com.volcengine.tos.internal.util.aborthook.DefaultAbortTosObjectInputStreamHook;
import com.volcengine.tos.internal.util.ratelimit.RateLimitedInputStream;
import com.volcengine.tos.model.object.AbortMultipartUploadInput;
import com.volcengine.tos.model.object.AbortMultipartUploadOutput;
import com.volcengine.tos.model.object.AppendObjectInput;
import com.volcengine.tos.model.object.AppendObjectOutput;
import com.volcengine.tos.model.object.CompleteMultipartUploadV2Input;
import com.volcengine.tos.model.object.CompleteMultipartUploadV2Output;
import com.volcengine.tos.model.object.CopyObjectV2Input;
import com.volcengine.tos.model.object.CopyObjectV2Output;
import com.volcengine.tos.model.object.CreateMultipartUploadInput;
import com.volcengine.tos.model.object.CreateMultipartUploadOutput;
import com.volcengine.tos.model.object.DeleteMultiObjectsV2Input;
import com.volcengine.tos.model.object.DeleteMultiObjectsV2Output;
import com.volcengine.tos.model.object.DeleteObjectInput;
import com.volcengine.tos.model.object.DeleteObjectOutput;
import com.volcengine.tos.model.object.DeleteObjectTaggingInput;
import com.volcengine.tos.model.object.DeleteObjectTaggingOutput;
import com.volcengine.tos.model.object.FetchObjectInput;
import com.volcengine.tos.model.object.FetchObjectOutput;
import com.volcengine.tos.model.object.GetObjectACLV2Input;
import com.volcengine.tos.model.object.GetObjectACLV2Output;
import com.volcengine.tos.model.object.GetObjectBasicOutput;
import com.volcengine.tos.model.object.GetObjectTaggingInput;
import com.volcengine.tos.model.object.GetObjectTaggingOutput;
import com.volcengine.tos.model.object.GetObjectV2Input;
import com.volcengine.tos.model.object.GetObjectV2Output;
import com.volcengine.tos.model.object.HeadObjectV2Input;
import com.volcengine.tos.model.object.HeadObjectV2Output;
import com.volcengine.tos.model.object.ListMultipartUploadsV2Input;
import com.volcengine.tos.model.object.ListMultipartUploadsV2Output;
import com.volcengine.tos.model.object.ListObjectVersionsV2Input;
import com.volcengine.tos.model.object.ListObjectVersionsV2Output;
import com.volcengine.tos.model.object.ListObjectsType2Input;
import com.volcengine.tos.model.object.ListObjectsType2Output;
import com.volcengine.tos.model.object.ListObjectsV2Input;
import com.volcengine.tos.model.object.ListObjectsV2Output;
import com.volcengine.tos.model.object.ListPartsInput;
import com.volcengine.tos.model.object.ListPartsOutput;
import com.volcengine.tos.model.object.ListedCommonPrefix;
import com.volcengine.tos.model.object.ListedObjectV2;
import com.volcengine.tos.model.object.ObjectTobeDeleted;
import com.volcengine.tos.model.object.PutFetchTaskInput;
import com.volcengine.tos.model.object.PutFetchTaskOutput;
import com.volcengine.tos.model.object.PutObjectACLInput;
import com.volcengine.tos.model.object.PutObjectACLOutput;
import com.volcengine.tos.model.object.PutObjectBasicInput;
import com.volcengine.tos.model.object.PutObjectInput;
import com.volcengine.tos.model.object.PutObjectOutput;
import com.volcengine.tos.model.object.PutObjectTaggingInput;
import com.volcengine.tos.model.object.PutObjectTaggingOutput;
import com.volcengine.tos.model.object.RenameObjectInput;
import com.volcengine.tos.model.object.RenameObjectOutput;
import com.volcengine.tos.model.object.RestoreObjectInput;
import com.volcengine.tos.model.object.RestoreObjectOutput;
import com.volcengine.tos.model.object.SetObjectMetaInput;
import com.volcengine.tos.model.object.SetObjectMetaOutput;
import com.volcengine.tos.model.object.TosObjectInputStream;
import com.volcengine.tos.model.object.UploadPartBasicInput;
import com.volcengine.tos.model.object.UploadPartCopyV2Input;
import com.volcengine.tos.model.object.UploadPartCopyV2Output;
import com.volcengine.tos.model.object.UploadPartV2Input;
import com.volcengine.tos.model.object.UploadPartV2Output;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TosObjectRequestHandler {
    private RequestHandler objectHandler;
    private TosRequestFactory factory;
    private boolean clientAutoRecognizeContentType;
    private boolean enableCrcCheck;

    public TosObjectRequestHandler(Transport transport, TosRequestFactory factory) {
        this.objectHandler = new RequestHandler(transport);
        this.factory = factory;
    }

    public TosObjectRequestHandler setTransport(Transport transport) {
        if (this.objectHandler == null) {
            this.objectHandler = new RequestHandler(transport);
        } else {
            this.objectHandler.setTransport(transport);
        }
        return this;
    }

    public Transport getTransport() {
        if (this.objectHandler != null) {
            return this.objectHandler.getTransport();
        }
        return null;
    }

    public TosRequestFactory getFactory() {
        return this.factory;
    }

    public TosObjectRequestHandler setFactory(TosRequestFactory factory) {
        this.factory = factory;
        return this;
    }

    public boolean isClientAutoRecognizeContentType() {
        return this.clientAutoRecognizeContentType;
    }

    public boolean isEnableCrcCheck() {
        return this.enableCrcCheck;
    }

    public TosObjectRequestHandler setClientAutoRecognizeContentType(boolean clientAutoRecognizeContentType) {
        this.clientAutoRecognizeContentType = clientAutoRecognizeContentType;
        return this;
    }

    public TosObjectRequestHandler setEnableCrcCheck(boolean enableCrcCheck) {
        this.enableCrcCheck = enableCrcCheck;
        return this;
    }

    public GetObjectV2Output getObject(GetObjectV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetObjectV2Input");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("versionId", input.getVersionID()).withQuery("response-cache-control", input.getResponseCacheControl()).withQuery("response-content-disposition", input.getResponseContentDisposition()).withQuery("response-content-encoding", input.getResponseContentEncoding()).withQuery("response-content-type", input.getResponseContentType()).withQuery("response-content-language", input.getResponseContentLanguage()).withQuery("response-expires", DateConverter.dateToRFC1123String(input.getResponseExpires())).withQuery("x-tos-process", input.getProcess()).withQuery("x-tos-save-bucket", input.getSaveBucket()).withQuery("x-tos-save-object", input.getSaveObject());
        TosRequest req = this.factory.build(builder, "GET", null);
        TosResponse response = this.objectHandler.doRequest(req, TosObjectRequestHandler.getExpectedCodes(input.getAllSettedHeaders()));
        return this.buildGetObjectV2Output(response, input.getRateLimiter(), input.getDataTransferListener());
    }

    private static List<Integer> getExpectedCodes(Map<String, String> headers) {
        ArrayList<Integer> codes = new ArrayList<Integer>(1);
        if (headers == null) {
            codes.add(200);
            return codes;
        }
        codes.add(200);
        if (headers.get("Range") != null) {
            codes.add(206);
        }
        return codes;
    }

    private GetObjectV2Output buildGetObjectV2Output(TosResponse response, RateLimiter rateLimiter, DataTransferListener dataTransferListener) {
        String serverCrc64ecma;
        GetObjectBasicOutput basicOutput = new GetObjectBasicOutput().setRequestInfo(response.RequestInfo()).parseFromTosResponse(response);
        InputStream content = response.getInputStream();
        if (rateLimiter != null) {
            content = new RateLimitedInputStream(content, rateLimiter);
        }
        if (dataTransferListener != null) {
            content = new SimpleDataTransferListenInputStream(content, dataTransferListener, response.getContentLength());
        }
        if (this.enableCrcCheck && response.getStatusCode() != 206 && StringUtils.isNotEmpty(serverCrc64ecma = response.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma"))) {
            content = new CheckCrc64AutoInputStream(content, new CRC64Checksum(), serverCrc64ecma);
        }
        return new GetObjectV2Output(basicOutput, new TosObjectInputStream(content)).setHook(new DefaultAbortTosObjectInputStreamHook(content, response.getSource()));
    }

    public HeadObjectV2Output headObject(HeadObjectV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "HeadObjectV2Input");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders());
        TosRequest req = this.factory.build(builder, "HEAD", null);
        return this.objectHandler.doRequest(req, TosObjectRequestHandler.getExpectedCodes(input.getAllSettedHeaders()), response -> new HeadObjectV2Output(new GetObjectBasicOutput().setRequestInfo(response.RequestInfo()).parseFromTosResponse((TosResponse)response)));
    }

    public DeleteObjectOutput deleteObject(DeleteObjectInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteObjectInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("versionId", input.getVersionID());
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.objectHandler.doRequest(req, 204, response -> new DeleteObjectOutput().setRequestInfo(response.RequestInfo()).setDeleteMarker(Boolean.parseBoolean(response.getHeaderWithKeyIgnoreCase("X-Tos-Delete-Marker"))).setVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")));
    }

    public DeleteMultiObjectsV2Output deleteMultiObjects(DeleteMultiObjectsV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteMultiObjectsV2Input");
        ParamsChecker.ensureNotNull(input.getObjects(), "objects to be deleted");
        this.ensureValidBucketName(input.getBucket());
        for (ObjectTobeDeleted objectTobeDeleted : input.getObjects()) {
            this.ensureValidKey(objectTobeDeleted.getKey());
        }
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withHeader("Content-MD5", marshalResult.getContentMD5()).withQuery("delete", "");
        TosRequest req = this.factory.build(builder, "POST", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<DeleteMultiObjectsV2Output>(){}).requestInfo(response.RequestInfo()));
    }

    private PutObjectOutput putObject(PutObjectBasicInput input, InputStream content) {
        ParamsChecker.ensureNotNull(input, "PutObjectBasicInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        content = this.ensureNotNullContent(content);
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withContentLength(input.getContentLength()).withHeader("x-tos-callback", input.getCallback()).withHeader("x-tos-callback-var", input.getCallbackVar());
        this.addContentType(builder, input.getKey());
        TosRequest req = this.factory.build(builder, "PUT", content).setEnableCrcCheck(this.enableCrcCheck).setRateLimiter(input.getRateLimiter()).setDataTransferListener(input.getDataTransferListener()).setReadLimit(input.getReadLimit());
        TosObjectRequestHandler.setRetryStrategy(req, content);
        return this.objectHandler.doRequest(req, 200, this::buildPutObjectOutput);
    }

    private InputStream ensureNotNullContent(InputStream content) {
        if (content == null) {
            content = new ByteArrayInputStream("".getBytes());
        }
        return content;
    }

    private static void setRetryStrategy(TosRequest request, InputStream stream) {
        boolean canRetry = stream.markSupported() || stream instanceof FileInputStream;
        request.setRetryableOnServerException(canRetry);
        request.setRetryableOnClientException(canRetry);
    }

    private PutObjectOutput buildPutObjectOutput(TosResponse res) {
        String callbackResult = StringUtils.toString(res.getInputStream(), "callbackResult");
        return new PutObjectOutput().setRequestInfo(res.RequestInfo()).setEtag(res.getHeaderWithKeyIgnoreCase("ETag")).setVersionID(res.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")).setHashCrc64ecma(res.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma")).setSseCustomerAlgorithm(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Algorithm")).setSseCustomerKeyMD5(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key-MD5")).setSseCustomerKey(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key")).setCallbackResult(callbackResult);
    }

    public PutObjectOutput putObject(PutObjectInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutObjectInput");
        return this.putObject(input.getPutObjectBasicInput(), input.getContent());
    }

    public AppendObjectOutput appendObject(AppendObjectInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "AppendObjectInput");
        if (this.enableCrcCheck && input.getOffset() > 0L && StringUtils.isEmpty(input.getPreHashCrc64ecma())) {
            throw new TosClientException("tos: client enable crc64 check but preHashCrc64ecma is not set", null);
        }
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        if (input.getContentLength() <= 0L) {
            throw new TosClientException("content length should be set in appendObject method.", null);
        }
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("append", "").withQuery("offset", String.valueOf(input.getOffset())).withContentLength(input.getContentLength());
        this.addContentType(builder, input.getKey());
        TosRequest req = this.factory.build(builder, "POST", input.getContent()).setRetryableOnServerException(false).setRetryableOnClientException(false).setEnableCrcCheck(this.enableCrcCheck).setCrc64InitValue(CRC64Utils.unsignedLongStringToLong(input.getPreHashCrc64ecma())).setRateLimiter(input.getRateLimiter()).setDataTransferListener(input.getDataTransferListener());
        return this.objectHandler.doRequest(req, 200, this::buildAppendObjectOutput);
    }

    private AppendObjectOutput buildAppendObjectOutput(TosResponse response) {
        long appendOffset;
        String nextOffset = response.getHeaderWithKeyIgnoreCase("X-Tos-Next-Append-Offset");
        try {
            appendOffset = Long.parseLong(nextOffset);
        }
        catch (NumberFormatException nfe) {
            throw new TosClientException("tos: server return unexpected Next-Append-Offset header: " + nextOffset, nfe);
        }
        return new AppendObjectOutput().setRequestInfo(response.RequestInfo()).setNextAppendOffset(appendOffset).setHashCrc64ecma(response.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma"));
    }

    public SetObjectMetaOutput setObjectMeta(SetObjectMetaInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "SetObjectMetaInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("metadata", "");
        this.addContentType(builder, input.getKey());
        TosRequest req = this.factory.build(builder, "POST", null);
        return this.objectHandler.doRequest(req, 200, response -> new SetObjectMetaOutput().setRequestInfo(response.RequestInfo()));
    }

    public ListObjectsV2Output listObjects(ListObjectsV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "ListObjectsV2Input");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("prefix", input.getPrefix()).withQuery("delimiter", input.getDelimiter()).withQuery("marker", input.getMarker()).withQuery("max-keys", TosUtils.convertInteger(input.getMaxKeys())).withQuery("reverse", String.valueOf(input.isReverse())).withQuery("encoding-type", input.getEncodingType());
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<ListObjectsV2Output>(){}).setRequestInfo(response.RequestInfo()));
    }

    public ListObjectsType2Output listObjectsType2(ListObjectsType2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "ListObjectsType2Input");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("list-type", "2").withQuery("prefix", input.getPrefix()).withQuery("delimiter", input.getDelimiter()).withQuery("start-after", input.getStartAfter()).withQuery("continuation-token", input.getContinuationToken()).withQuery("max-keys", TosUtils.convertInteger(input.getMaxKeys())).withQuery("encoding-type", input.getEncodingType());
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<ListObjectsType2Output>(){}).setRequestInfo(response.RequestInfo()));
    }

    public ListObjectsType2Output listObjectsType2UntilFinished(ListObjectsType2Input input) {
        ParamsChecker.ensureNotNull(input, "ListObjectsType2Input");
        if (input.isListOnlyOnce()) {
            return this.listObjectsType2(input);
        }
        int mk = input.getMaxKeys() > 0 ? input.getMaxKeys() : 1000;
        int totalRecords = 0;
        List<ListedCommonPrefix> commonPrefixes = null;
        List<ListedObjectV2> contents = null;
        ListObjectsType2Output tmp = null;
        String continuationToken = input.getContinuationToken();
        boolean listFinished = false;
        while (!listFinished) {
            tmp = this.listObjectsType2(input.setContinuationToken(continuationToken));
            if (tmp.getCommonPrefixes() != null) {
                if (commonPrefixes == null) {
                    commonPrefixes = tmp.getCommonPrefixes();
                } else {
                    commonPrefixes.addAll(tmp.getCommonPrefixes());
                }
            }
            if (tmp.getContents() != null) {
                if (contents == null) {
                    contents = tmp.getContents();
                } else {
                    contents.addAll(tmp.getContents());
                }
            }
            continuationToken = tmp.getNextContinuationToken();
            listFinished = this.isListFinished(tmp.isTruncated(), mk, totalRecords += tmp.getKeyCount());
        }
        return tmp.setCommonPrefixes(commonPrefixes).setContents(contents).setKeyCount(totalRecords);
    }

    private boolean isListFinished(boolean isTruncated, int mk, int totalRecords) {
        boolean returnMaxKeysRecord = mk == totalRecords;
        return returnMaxKeysRecord || !isTruncated;
    }

    public ListObjectVersionsV2Output listObjectVersions(ListObjectVersionsV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "ListObjectVersionsV2Input");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("prefix", input.getPrefix()).withQuery("delimiter", input.getDelimiter()).withQuery("key-marker", input.getKeyMarker()).withQuery("max-keys", TosUtils.convertInteger(input.getMaxKeys())).withQuery("encoding-type", input.getEncodingType()).withQuery("version-id-marker", input.getVersionIDMarker()).withQuery("versions", "");
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<ListObjectVersionsV2Output>(){}).setRequestInfo(response.RequestInfo()));
    }

    public CopyObjectV2Output copyObject(CopyObjectV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "CopyObjectV2Input");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        this.ensureValidBucketName(input.getSrcBucket());
        this.ensureValidKey(input.getSrcKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("versionId", input.getSrcVersionID());
        TosRequest req = this.factory.buildWithCopy(builder, "PUT", input.getSrcBucket(), input.getSrcKey());
        return this.objectHandler.doRequest(req, 200, this::buildCopyObjectV2Output);
    }

    private CopyObjectV2Output buildCopyObjectV2Output(TosResponse response) {
        String rspMsg = StringUtils.toString(response.getInputStream(), "copy result");
        try {
            CopyObjectV2Output output = PayloadConverter.parsePayload(rspMsg, new TypeReference<CopyObjectV2Output>(){});
            return output.setRequestInfo(response.RequestInfo()).setVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")).setSourceVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Copy-Source-Version-Id")).setHashCrc64ecma(response.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma"));
        }
        catch (TosClientException e) {
            ServerExceptionJson errMsg = PayloadConverter.parsePayload(rspMsg, new TypeReference<ServerExceptionJson>(){});
            throw new TosServerException(response.getStatusCode(), errMsg.getCode(), errMsg.getMessage(), errMsg.getRequestID(), errMsg.getHostID());
        }
    }

    public UploadPartCopyV2Output uploadPartCopy(UploadPartCopyV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "UploadPartCopyV2Input");
        ParamsChecker.ensureNotNull(input.getUploadID(), "UploadID");
        ParamsChecker.isValidPartNumber(input.getPartNumber());
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        this.ensureValidBucketName(input.getSourceBucket());
        this.ensureValidKey(input.getSourceKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("partNumber", TosUtils.convertInteger(input.getPartNumber())).withQuery("uploadId", input.getUploadID()).withQuery("versionId", input.getSourceVersionID());
        TosRequest req = this.factory.buildWithCopy(builder, "PUT", input.getSourceBucket(), input.getSourceKey());
        return this.objectHandler.doRequest(req, 200, response -> this.buildUploadPartCopyV2Output(input, (TosResponse)response));
    }

    private UploadPartCopyV2Output buildUploadPartCopyV2Output(UploadPartCopyV2Input input, TosResponse response) {
        String rspMsg = StringUtils.toString(response.getInputStream(), "copy result");
        try {
            UploadPartCopyOutputJson out = PayloadConverter.parsePayload(rspMsg, new TypeReference<UploadPartCopyOutputJson>(){});
            return new UploadPartCopyV2Output().requestInfo(response.RequestInfo()).copySourceVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Copy-Source-Version-Id")).partNumber(input.getPartNumber()).etag(out.getEtag()).lastModified(out.getLastModified());
        }
        catch (TosClientException e) {
            ServerExceptionJson errMsg = PayloadConverter.parsePayload(rspMsg, new TypeReference<ServerExceptionJson>(){});
            throw new TosServerException(response.getStatusCode(), errMsg.getCode(), errMsg.getMessage(), errMsg.getRequestID(), errMsg.getHostID());
        }
    }

    public PutObjectACLOutput putObjectAcl(PutObjectACLInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutObjectACLInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("acl", "").withHeader("X-Tos-Acl", input.getAcl() == null ? null : input.getAcl().toString()).withHeader("X-Tos-Grant-Full-Control", input.getGrantFullControl()).withHeader("X-Tos-Grant-Read", input.getGrantRead()).withHeader("X-Tos-Grant-Read-Acp", input.getGrantReadAcp()).withHeader("X-Tos-Grant-Write-Acp", input.getGrantWriteAcp());
        byte[] content = new byte[]{};
        if (input.getObjectAclRules() != null) {
            TosMarshalResult res = PayloadConverter.serializePayloadAndComputeMD5(input.getObjectAclRules());
            content = res.getData();
            builder.withHeader("Content-MD5", res.getContentMD5());
        }
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(content)).setContentLength(content.length);
        return this.objectHandler.doRequest(req, 200, response -> new PutObjectACLOutput().requestInfo(response.RequestInfo()));
    }

    public GetObjectACLV2Output getObjectAcl(GetObjectACLV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetObjectACLV2Input");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("acl", "");
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, this::buildGetObjectACLV2Output);
    }

    private GetObjectACLV2Output buildGetObjectACLV2Output(TosResponse response) {
        return PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<GetObjectACLV2Output>(){}).setRequestInfo(response.RequestInfo()).setVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id"));
    }

    public PutObjectTaggingOutput putObjectTagging(PutObjectTaggingInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutObjectTaggingInput");
        ParamsChecker.ensureNotNull(input.getTagSet(), "TagSet");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("tagging", "").withQuery("versionId", input.getVersionID()).withHeader("Content-MD5", marshalResult.getContentMD5());
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.objectHandler.doRequest(req, 200, response -> new PutObjectTaggingOutput().setRequestInfo(response.RequestInfo()).setVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")));
    }

    public GetObjectTaggingOutput getObjectTagging(GetObjectTaggingInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetObjectTaggingInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("tagging", "").withQuery("versionId", input.getVersionID());
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetObjectTaggingOutput>(){}).setRequestInfo(res.RequestInfo()).setVersionID(res.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")));
    }

    public DeleteObjectTaggingOutput deleteObjectTagging(DeleteObjectTaggingInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteObjectTaggingInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("tagging", "");
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.objectHandler.doRequest(req, 204, res -> new DeleteObjectTaggingOutput().setRequestInfo(res.RequestInfo()).setVersionID(res.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")));
    }

    public FetchObjectOutput fetchObject(FetchObjectInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "FetchObjectInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        ParamsChecker.ensureNotNull(input.getUrl(), "URL");
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("fetch", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        TosRequest req = this.factory.build(builder, "POST", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<FetchObjectOutput>(){}).setRequestInfo(response.RequestInfo()).setVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")).setSsecAlgorithm(response.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Algorithm")).setSsecKeyMD5(response.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key-MD5")));
    }

    public PutFetchTaskOutput putFetchTask(PutFetchTaskInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutFetchTaskInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        ParamsChecker.ensureNotNull(input.getUrl(), "URL");
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", input.getAllSettedHeaders()).withQuery("fetchTask", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        TosRequest req = this.factory.build(builder, "POST", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<PutFetchTaskOutput>(){}).setRequestInfo(response.RequestInfo()));
    }

    public CreateMultipartUploadOutput createMultipartUpload(CreateMultipartUploadInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "CreateMultipartUploadInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("uploads", "");
        this.addContentType(builder, input.getKey());
        TosRequest req = this.factory.build(builder, "POST", null).setRetryableOnClientException(false);
        return this.objectHandler.doRequest(req, 200, this::buildCreateMultipartUploadOutput);
    }

    private CreateMultipartUploadOutput buildCreateMultipartUploadOutput(TosResponse response) {
        CreateMultipartUploadOutputJson upload = PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<CreateMultipartUploadOutputJson>(){});
        return new CreateMultipartUploadOutput().setRequestInfo(response.RequestInfo()).setBucket(upload.getBucket()).setKey(upload.getKey()).setUploadID(upload.getUploadID()).setEncodingType(upload.getEncodingType()).setSseCustomerAlgorithm(response.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Algorithm")).setSseCustomerMD5(response.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key-MD5")).setSseCustomerKey(response.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key"));
    }

    private UploadPartV2Output buildUploadPartV2Output(TosResponse res, int partNumber) {
        return new UploadPartV2Output().setRequestInfo(res.RequestInfo()).setPartNumber(partNumber).setEtag(res.getHeaderWithKeyIgnoreCase("ETag")).setSsecAlgorithm(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Algorithm")).setSsecKeyMD5(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key-MD5")).setHashCrc64ecma(res.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma"));
    }

    private UploadPartV2Output uploadPart(UploadPartBasicInput input, long contentLength, InputStream content) {
        ParamsChecker.ensureNotNull(input, "UploadPartBasicInput");
        ParamsChecker.ensureNotNull(input.getUploadID(), "uploadID");
        ParamsChecker.ensureNotNull(content, "InputStream");
        ParamsChecker.isValidPartNumber(input.getPartNumber());
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("uploadId", input.getUploadID()).withQuery("partNumber", TosUtils.convertInteger(input.getPartNumber())).withContentLength(contentLength);
        TosRequest req = this.factory.build(builder, "PUT", content).setEnableCrcCheck(this.enableCrcCheck).setRateLimiter(input.getRateLimiter()).setDataTransferListener(input.getDataTransferListener()).setReadLimit(input.getReadLimit());
        TosObjectRequestHandler.setRetryStrategy(req, content);
        return this.objectHandler.doRequest(req, 200, response -> this.buildUploadPartV2Output((TosResponse)response, input.getPartNumber()));
    }

    public UploadPartV2Output uploadPart(UploadPartV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "UploadPartV2Input");
        return this.uploadPart(input.getUploadPartBasicInput(), input.getContentLength(), input.getContent());
    }

    public CompleteMultipartUploadV2Output completeMultipartUpload(CompleteMultipartUploadV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "CompleteMultipartUploadV2Input");
        ParamsChecker.ensureNotNull(input.getUploadID(), "uploadID");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("uploadId", input.getUploadID()).withHeader("x-tos-callback", input.getCallback()).withHeader("x-tos-callback-var", input.getCallbackVar());
        String contentMd5 = null;
        byte[] data = new byte[]{};
        if (!input.isCompleteAll()) {
            this.ensureUploadedPartsNotNull(input);
            TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
            contentMd5 = marshalResult.getContentMD5();
            data = marshalResult.getData();
        } else {
            this.ensureUploadedPartsNull(input);
            builder.withHeader("x-tos-complete-all", "yes");
        }
        builder.withHeader("Content-MD5", contentMd5);
        TosRequest req = this.factory.build(builder, "POST", new ByteArrayInputStream(data)).setContentLength(data.length).setRetryableOnClientException(false);
        ArrayList<Integer> unexpectedCodes = new ArrayList<Integer>();
        unexpectedCodes.add(203);
        return this.objectHandler.doRequest(req, 200, unexpectedCodes, response -> {
            boolean hasCallbackResult = StringUtils.isNotEmpty(input.getCallback());
            return this.buildCompleteMultipartUploadOutput((TosResponse)response, hasCallbackResult);
        });
    }

    private void ensureUploadedPartsNull(CompleteMultipartUploadV2Input input) {
        if (input != null && input.getUploadedParts() != null && input.getUploadedParts().size() != 0) {
            throw new TosClientException("tos: you should not set uploadedParts while using completeAll.", null);
        }
    }

    private void ensureUploadedPartsNotNull(CompleteMultipartUploadV2Input input) {
        if (input == null || input.getUploadedParts() == null || input.getUploadedParts().size() == 0) {
            throw new TosClientException("tos: you must specify at least one part.", null);
        }
    }

    private CompleteMultipartUploadV2Output buildCompleteMultipartUploadOutput(TosResponse response, boolean hasCallbackResult) {
        String respBody = StringUtils.toString(response.getInputStream(), "response body");
        CompleteMultipartUploadV2Output output = new CompleteMultipartUploadV2Output();
        if (hasCallbackResult) {
            output.setCallbackResult(respBody);
            output.setEtag(response.getHeaderWithKeyIgnoreCase("ETag"));
            output.setLocation(response.getHeaderWithKeyIgnoreCase("Location"));
        } else {
            output = PayloadConverter.parsePayload(respBody, new TypeReference<CompleteMultipartUploadV2Output>(){});
        }
        return output.setRequestInfo(response.RequestInfo()).setVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")).setHashCrc64ecma(response.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma"));
    }

    public AbortMultipartUploadOutput abortMultipartUpload(AbortMultipartUploadInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "AbortMultipartUploadInput");
        ParamsChecker.ensureNotNull(input.getUploadID(), "uploadID");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("uploadId", input.getUploadID());
        TosRequest req = this.factory.build(builder, "DELETE", null).setRetryableOnClientException(false);
        return this.objectHandler.doRequest(req, 204, response -> new AbortMultipartUploadOutput().setRequestInfo(response.RequestInfo()));
    }

    public ListPartsOutput listParts(ListPartsInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "ListPartsInput");
        ParamsChecker.ensureNotNull(input.getUploadID(), "uploadID");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        if (input.getMaxParts() < 0 || input.getPartNumberMarker() < 0) {
            throw new TosClientException("ListPartsInput maxParts or partNumberMarker is small than 0", null);
        }
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("uploadId", input.getUploadID()).withQuery("max-parts", TosUtils.convertInteger(input.getMaxParts())).withQuery("part-number-marker", TosUtils.convertInteger(input.getPartNumberMarker())).withQuery("encoding-type", input.getEncodingType());
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<ListPartsOutput>(){}).setRequestInfo(response.RequestInfo()));
    }

    public ListMultipartUploadsV2Output listMultipartUploads(ListMultipartUploadsV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "ListMultipartUploadsV2Input");
        this.ensureValidBucketName(input.getBucket());
        if (input.getMaxUploads() < 0) {
            throw new TosClientException("ListMultipartUploadsV2Input maxUploads is small than 0", null);
        }
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("uploads", "").withQuery("prefix", input.getPrefix()).withQuery("delimiter", input.getDelimiter()).withQuery("key-marker", input.getKeyMarker()).withQuery("upload-id-marker", input.getUploadIDMarker()).withQuery("max-uploads", TosUtils.convertInteger(input.getMaxUploads())).withQuery("encoding-type", input.getEncodingType());
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<ListMultipartUploadsV2Output>(){}).setRequestInfo(response.RequestInfo()));
    }

    public RenameObjectOutput renameObject(RenameObjectInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "RenameObjectInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        this.ensureValidKey(input.getNewKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("name", input.getNewKey()).withQuery("rename", "");
        TosRequest req = this.factory.build(builder, "PUT", null);
        return this.objectHandler.doRequest(req, 204, response -> new RenameObjectOutput().setRequestInfo(response.RequestInfo()));
    }

    public RestoreObjectOutput restoreObject(RestoreObjectInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "RestoreObjectInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withHeader("Content-MD5", marshalResult.getContentMD5()).withQuery("restore", "").withQuery("versionId", input.getVersionID());
        TosRequest req = this.factory.build(builder, "POST", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.objectHandler.doRequest(req, this.restoreObjectExceptedCodes(), response -> new RestoreObjectOutput().setRequestInfo(response.RequestInfo()));
    }

    private List<Integer> restoreObjectExceptedCodes() {
        ArrayList<Integer> expectedCodes = new ArrayList<Integer>();
        expectedCodes.add(200);
        expectedCodes.add(202);
        return expectedCodes;
    }

    private void addContentType(RequestBuilder rb, String objectKey) throws TosClientException {
        String contentType = rb.getHeaders().get("Content-Type");
        if (StringUtils.isEmpty(contentType) && this.clientAutoRecognizeContentType && rb.isAutoRecognizeContentType()) {
            contentType = MimeType.getInstance().getMimetype(objectKey);
            rb.withHeader("Content-Type", contentType);
        }
    }

    private void ensureValidBucketName(String bucket) {
        if (this.factory.isCustomDomain()) {
            return;
        }
        ParamsChecker.isValidBucketName(bucket);
    }

    private void ensureValidKey(String key) {
        ParamsChecker.isValidKey(key);
    }
}

