/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.utils;

import com.vmware.l10n.record.model.RecordModel;
import com.vmware.l10n.source.dto.SourceAPIResponseDTO;
import com.vmware.l10n.utils.MapUtil;
import com.vmware.vip.common.i18n.dto.SingleComponentDTO;
import com.vmware.vip.common.i18n.status.APIResponseStatus;
import com.vmware.vip.common.l10n.source.dto.ComponentMessagesDTO;
import com.vmware.vip.common.l10n.source.dto.StringSourceDTO;
import java.util.Iterator;
import java.util.Map;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public class SourceUtils {
    private static Logger logger = LoggerFactory.getLogger(SourceUtils.class);

    private SourceUtils() {
    }

    public static StringSourceDTO createSourceDTO(String productName, String version, String component, String locale, String key, String source, String commentForSource, String sourceFormat) {
        StringSourceDTO stringSourceDTO = new StringSourceDTO();
        stringSourceDTO.setProductName(productName);
        stringSourceDTO.setComponent(component);
        stringSourceDTO.setVersion(version);
        stringSourceDTO.setLocale(locale);
        stringSourceDTO.setKey(key);
        stringSourceDTO.setSource(source);
        stringSourceDTO.setComment(commentForSource);
        stringSourceDTO.setSourceFormat(sourceFormat);
        return stringSourceDTO;
    }

    public static SourceAPIResponseDTO handleSourceResponse(boolean isSourceCached) {
        SourceAPIResponseDTO sourceAPIResponseDTO = new SourceAPIResponseDTO();
        if (isSourceCached) {
            sourceAPIResponseDTO.setResponse(APIResponseStatus.TRANSLATION_COLLECT_REQUEST_SUCCESS);
        } else {
            sourceAPIResponseDTO.setResponse(APIResponseStatus.TRANSLATION_COLLECT_FAILURE);
        }
        return sourceAPIResponseDTO;
    }

    public static SingleComponentDTO mergeCacheWithBundle(SingleComponentDTO cachedComponentSourceDTO, String componentJSON) {
        ComponentMessagesDTO componentMessagesDTO = new ComponentMessagesDTO();
        BeanUtils.copyProperties((Object)cachedComponentSourceDTO, (Object)componentMessagesDTO);
        if (!StringUtils.isEmpty((Object)componentJSON)) {
            JSONParser parser = new JSONParser();
            ContainerFactory containerFactory = MapUtil.getContainerFactory();
            Map bundle = null;
            try {
                bundle = (Map)parser.parse(componentJSON, containerFactory);
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (bundle != null && !bundle.isEmpty()) {
                Map messages = (Map)bundle.get("messages");
                Iterator it = ((Map)cachedComponentSourceDTO.getMessages()).entrySet().iterator();
                boolean isChanged = false;
                while (it.hasNext()) {
                    String v;
                    Map.Entry entry = it.next();
                    String key = (String)entry.getKey();
                    String value = entry.getValue() == null ? "" : (String)entry.getValue();
                    String string = v = messages.get(key) == null ? "" : (String)messages.get(key);
                    if (!value.equals(v) && !isChanged) {
                        isChanged = true;
                    }
                    MapUtil.updateKeyValue((Map)messages, (String)key, (Object)value);
                }
                if (isChanged) {
                    componentMessagesDTO.setId(System.currentTimeMillis());
                } else {
                    componentMessagesDTO.setId(Long.parseLong(bundle.get("id") == null ? "0" : bundle.get("id").toString()));
                }
                componentMessagesDTO.setMessages((Object)messages);
            }
        }
        return componentMessagesDTO;
    }

    public static RecordModel parseKeyStr2Record(String key, String productParentDir, long lastModify) {
        String keyStr = key.replace(productParentDir, "");
        String[] keyArry = keyStr.split("/");
        RecordModel record = new RecordModel();
        record.setProduct(keyArry[0]);
        record.setVersion(keyArry[1]);
        record.setComponent(keyArry[2]);
        record.setLocale("latest");
        record.setStatus(lastModify);
        return record;
    }
}

