/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.vmware.l10n.conf.S3Cfg;
import com.vmware.l10n.conf.S3Client;
import com.vmware.vip.common.i18n.dto.SingleComponentDTO;
import com.vmware.vip.common.i18n.resourcefile.ResourceFilePathGetter;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="S3Util")
@Profile(value={"s3"})
public class S3Util {
    private static Logger logger = LoggerFactory.getLogger(S3Util.class);
    private static Random random = new Random(System.currentTimeMillis());
    private static long retryInterval = 500L;
    private static long deadlockInterval = 30000L;
    private static long waitToLock = 10000L;
    @Autowired
    private S3Cfg config;
    @Autowired
    private S3Client s3Client;

    public String readBundle(String basePath, SingleComponentDTO compDTO) {
        String bundlePath = S3Util.getBundleFilePath((String)basePath, (SingleComponentDTO)compDTO);
        return this.s3Client.readObject(bundlePath);
    }

    public boolean writeBundle(String basePath, SingleComponentDTO compDTO) throws JsonProcessingException {
        String bundlePath = S3Util.getBundleFilePath((String)basePath, (SingleComponentDTO)compDTO);
        this.s3Client.putObject(bundlePath, compDTO.toPrettyString());
        return true;
    }

    public boolean isBundleExist(String basePath, SingleComponentDTO singleComponentDTO) {
        String bundlePath = S3Util.getBundleFilePath((String)basePath, (SingleComponentDTO)singleComponentDTO);
        return this.s3Client.isObjectExist(bundlePath);
    }

    public static String getBundleFilePath(String basePath, SingleComponentDTO dto) {
        if (StringUtils.isEmpty((Object)dto.getComponent())) {
            dto.setComponent("default");
        }
        return S3Util.genProductVersionS3Path((String)basePath, (String)dto.getProductName(), (String)dto.getVersion()) + dto.getComponent() + "/" + ResourceFilePathGetter.getLocalizedJSONFileName((String)dto.getLocale());
    }

    public static String genProductVersionS3Path(String basePath, String productName, String version) {
        StringBuilder path = new StringBuilder();
        path.append(basePath);
        path.append(productName);
        path.append("/");
        path.append(version);
        path.append("/");
        return path.toString();
    }
}

