/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.translation.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.vmware.l10n.translation.dao.SingleComponentDao;
import com.vmware.l10n.translation.dto.ComponentMessagesDTO;
import com.vmware.l10n.translation.service.TranslationSyncServerService;
import com.vmware.l10n.utils.MapUtil;
import com.vmware.vip.common.constants.TranslationQueryStatusType;
import com.vmware.vip.common.i18n.dto.UpdateTranslationDTO;
import com.vmware.vip.common.l10n.exception.L10nAPIException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class TranslationSyncServerServiceImpl
implements TranslationSyncServerService {
    private static Logger LOGGER = LoggerFactory.getLogger(TranslationSyncServerServiceImpl.class);
    @Autowired
    private SingleComponentDao singleComponentDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateTranslation(ComponentMessagesDTO componentMessagesDTO) throws L10nAPIException, JsonProcessingException {
        LOGGER.info("Start Update transaltion for: [" + componentMessagesDTO.getProductName() + "], [" + componentMessagesDTO.getVersion() + "], [" + componentMessagesDTO.getComponent() + "], [" + componentMessagesDTO.getLocale() + "]");
        if (!this.singleComponentDao.lockFile(componentMessagesDTO)) {
            return false;
        }
        try {
            componentMessagesDTO = this.mergeComponentMessagesDTOWithFile(componentMessagesDTO);
            LOGGER.info("Update the local bundle file");
            boolean flag = this.singleComponentDao.writeTranslationToFile(componentMessagesDTO);
            LOGGER.info("End of Update transaltion");
            boolean bl = flag;
            return bl;
        }
        finally {
            this.singleComponentDao.unlockFile(componentMessagesDTO);
        }
    }

    public List<UpdateTranslationDTO.UpdateTranslationDataDTO.TranslationDTO> updateBatchTranslation(List<ComponentMessagesDTO> componentMessagesDTOList) throws L10nAPIException, JsonProcessingException {
        ArrayList<UpdateTranslationDTO.UpdateTranslationDataDTO.TranslationDTO> translationDTOList = new ArrayList<UpdateTranslationDTO.UpdateTranslationDataDTO.TranslationDTO>();
        for (ComponentMessagesDTO componentMessagesDTO : componentMessagesDTOList) {
            if (this.updateTranslation(componentMessagesDTO)) continue;
            UpdateTranslationDTO.UpdateTranslationDataDTO.TranslationDTO translationDTO = new UpdateTranslationDTO.UpdateTranslationDataDTO.TranslationDTO();
            translationDTO.setComponent(componentMessagesDTO.getComponent());
            translationDTO.setLocale(componentMessagesDTO.getLocale());
            translationDTO.setMessages((Map)componentMessagesDTO.getMessages());
            translationDTOList.add(translationDTO);
        }
        return translationDTOList;
    }

    private ComponentMessagesDTO mergeComponentMessagesDTOWithFile(ComponentMessagesDTO componentMessagesDTO) throws L10nAPIException {
        ComponentMessagesDTO paramComponentMessagesDTO = new ComponentMessagesDTO();
        BeanUtils.copyProperties((Object)componentMessagesDTO, (Object)paramComponentMessagesDTO);
        ComponentMessagesDTO result = this.singleComponentDao.getTranslationFromFile(paramComponentMessagesDTO);
        if (!StringUtils.isEmpty((Object)result) && !StringUtils.isEmpty((Object)result.getStatus()) && result.getStatus().equals("Translation" + TranslationQueryStatusType.FileFound)) {
            Object messageObj = result.getMessages();
            if (!StringUtils.isEmpty((Object)messageObj)) {
                Map messages = (Map)messageObj;
                Iterator it = ((Map)componentMessagesDTO.getMessages()).entrySet().iterator();
                boolean isChanged = false;
                while (it.hasNext()) {
                    String v;
                    Map.Entry entry = it.next();
                    String key = (String)entry.getKey();
                    String value = entry.getValue() == null ? "" : (String)entry.getValue();
                    String string = v = messages.get(key) == null ? "" : (String)messages.get(key);
                    if (!value.equals(v) && !isChanged) {
                        isChanged = true;
                    }
                    MapUtil.updateKeyValue((Map)messages, (String)key, (Object)value);
                }
                if (isChanged) {
                    componentMessagesDTO.setId(System.currentTimeMillis());
                } else {
                    componentMessagesDTO.setId(result.getId());
                }
                componentMessagesDTO.setMessages((Object)messages);
                return componentMessagesDTO;
            }
            return componentMessagesDTO;
        }
        return componentMessagesDTO;
    }

    public void saveCreationInfo(UpdateTranslationDTO updateTranslationDTO) {
        this.singleComponentDao.saveCreationInfo(updateTranslationDTO);
    }
}

