/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.translation.dao.impl;

import com.vmware.l10n.translation.dao.SingleComponentDao;
import com.vmware.l10n.translation.dto.ComponentMessagesDTO;
import com.vmware.l10n.translation.readers.LocalJSONReader;
import com.vmware.vip.common.constants.ConstantsFile;
import com.vmware.vip.common.constants.TranslationQueryStatusType;
import com.vmware.vip.common.exceptions.VIPResourceOperationException;
import com.vmware.vip.common.i18n.dto.BaseDTO;
import com.vmware.vip.common.i18n.dto.SingleComponentDTO;
import com.vmware.vip.common.i18n.dto.UpdateTranslationDTO;
import com.vmware.vip.common.i18n.resourcefile.ResourceFilePathGetter;
import com.vmware.vip.common.l10n.exception.L10nAPIException;
import com.vmware.vip.common.utils.JSONUtils;
import com.vmware.vip.common.utils.SortJSONUtils;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
@Profile(value={"bundle"})
public class LocalSingleComponentDaoImpl
implements SingleComponentDao {
    @Value(value="${translation.bundle.file.basepath}")
    private String basePath;
    private static Logger LOGGER = LoggerFactory.getLogger(LocalSingleComponentDaoImpl.class);

    public ComponentMessagesDTO getTranslationFromFile(ComponentMessagesDTO componentMessagesDTO) throws L10nAPIException {
        LOGGER.info("[getLocalTranslation]");
        String result = "";
        String component = componentMessagesDTO.getComponent();
        if (StringUtils.isEmpty((Object)component)) {
            component = "default";
        }
        String filepath = ConstantsFile.L10N_BUNDLES_PATH + ResourceFilePathGetter.getProductVersionConcatName((BaseDTO)componentMessagesDTO) + "/" + component + "/" + ResourceFilePathGetter.getLocalizedJSONFileName((String)componentMessagesDTO.getLocale());
        String defaultFilePath = filepath.substring(0, filepath.lastIndexOf("messages") + 8) + "_en.json";
        LOGGER.info("Read content from file: {}", (Object)this.basePath);
        if (new File(this.basePath + filepath).exists()) {
            componentMessagesDTO.setStatus("Translation" + TranslationQueryStatusType.FileFound.toString());
            result = new LocalJSONReader().readLocalJSONFile(this.basePath + filepath);
        } else {
            componentMessagesDTO.setStatus("Translation" + TranslationQueryStatusType.FileNotFound.toString());
            result = new LocalJSONReader().readLocalJSONFile(this.basePath + defaultFilePath);
        }
        if (StringUtils.isEmpty((Object)result)) {
            componentMessagesDTO.setMessages((Object)result);
            componentMessagesDTO.setStatus(TranslationQueryStatusType.ComponentNotFound.toString());
            return componentMessagesDTO;
        }
        SingleComponentDTO caseComponentMessagesDTO = new SingleComponentDTO();
        try {
            caseComponentMessagesDTO = SingleComponentDTO.getSingleComponentDTOWithLinkedMessages((String)result);
            caseComponentMessagesDTO.setProductName(componentMessagesDTO.getProductName());
            caseComponentMessagesDTO.setVersion(componentMessagesDTO.getVersion());
            caseComponentMessagesDTO.setStatus(componentMessagesDTO.getStatus());
        }
        catch (ParseException e) {
            throw new L10nAPIException("Parse json failed.", (Throwable)e);
        }
        ComponentMessagesDTO msgDTO = new ComponentMessagesDTO();
        BeanUtils.copyProperties((Object)caseComponentMessagesDTO, (Object)msgDTO);
        return msgDTO;
    }

    public boolean writeTranslationToFile(ComponentMessagesDTO componentMessagesDTO) {
        String filepath;
        File targetFile;
        String component = componentMessagesDTO.getComponent();
        if (StringUtils.isEmpty((Object)component)) {
            component = "default";
        }
        if ((targetFile = new File(this.basePath + (filepath = ConstantsFile.L10N_BUNDLES_PATH + ResourceFilePathGetter.getProductVersionConcatName((BaseDTO)componentMessagesDTO) + "/" + component + "/" + ResourceFilePathGetter.getLocalizedJSONFileName((String)componentMessagesDTO.getLocale())))).exists()) {
            LOGGER.info("The bunlde file path {}{} is found, update the bundle file.", (Object)this.basePath, (Object)filepath);
            try {
                SortJSONUtils.writeJSONObjectToJSONFile((String)(this.basePath + filepath), (SingleComponentDTO)componentMessagesDTO);
                LOGGER.info("The bunlde file {}{} have updated sucessfully", (Object)this.basePath, (Object)filepath);
                return true;
            }
            catch (VIPResourceOperationException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        LOGGER.info("The bunlde file path {}{} is not found, cascade create the dir,add new bundle file ", (Object)this.basePath, (Object)filepath);
        try {
            FileUtils.write((File)targetFile, (CharSequence)"", (String)"UTF-8", (boolean)true);
            SortJSONUtils.writeJSONObjectToJSONFile((String)(this.basePath + filepath), (SingleComponentDTO)componentMessagesDTO);
            LOGGER.info("The bunlde file {}{} have updated sucessfully", (Object)this.basePath, (Object)filepath);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean lockFile(ComponentMessagesDTO componentMessagesDTO) {
        return true;
    }

    public void unlockFile(ComponentMessagesDTO componentMessagesDTO) {
    }

    public void saveCreationInfo(UpdateTranslationDTO updateTranslationDTO) {
        UpdateTranslationDTO.UpdateTranslationDataDTO transData = updateTranslationDTO.getData();
        String opId = "";
        UpdateTranslationDTO.UpdateTranslationDataDTO.CreationDTO creationDTO = transData.getCreation();
        if (creationDTO != null) {
            opId = creationDTO.getOperationid();
        }
        String filepath = this.basePath + ConstantsFile.L10N_BUNDLES_PATH + ResourceFilePathGetter.getProductVersionConcatName((BaseDTO)transData) + "/creation.json";
        Map json = JSONUtils.getMapFromJsonFile((String)filepath);
        List groups = transData.getTranslation();
        for (int i = 0; i < groups.size(); ++i) {
            json.put(((UpdateTranslationDTO.UpdateTranslationDataDTO.TranslationDTO)groups.get(i)).getLocale(), opId);
        }
        File pareFile = new File(filepath);
        if (!pareFile.getParentFile().exists()) {
            pareFile.getParentFile().mkdirs();
        }
        JSONUtils.writeMapToJsonFile((String)filepath, (Map)json);
    }
}

