/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.source.service.impl;

import com.vmware.l10n.source.dao.SourceDao;
import com.vmware.l10n.source.service.SyncLocalBundleService;
import com.vmware.l10n.utils.DiskQueueUtils;
import com.vmware.vip.common.l10n.exception.L10nAPIException;
import com.vmware.vip.common.l10n.source.dto.ComponentMessagesDTO;
import com.vmware.vip.common.l10n.source.dto.ComponentSourceDTO;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SyncLocalBundleServiceImpl
implements SyncLocalBundleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncLocalBundleServiceImpl.class);
    private static final String LOCAL_STR = "local";
    @Value(value="${source.bundle.file.basepath}")
    private String basePath;
    @Value(value="${spring.profiles.active}")
    private String activeDaoType;
    @Value(value="${grm.server.url}")
    private String remoteGRMURL;
    @Value(value="${vip.server.url}")
    private String remoteVIPURL;
    @Autowired
    private SourceDao sourceDao;

    private void processSendFilePath(String basePath, File source) throws IOException {
        if (!this.remoteGRMURL.equalsIgnoreCase(LOCAL_STR)) {
            DiskQueueUtils.moveFile2GRMPath((String)basePath, (File)source);
        } else if (!this.remoteVIPURL.equalsIgnoreCase(LOCAL_STR)) {
            DiskQueueUtils.moveFile2I18nPath((String)basePath, (File)source);
        } else {
            DiskQueueUtils.delQueueFile((File)source);
        }
    }

    public synchronized void mergeSourceToLocalBundle() {
        LOGGER.debug("--Synchronize the updated source to local--");
        List queueFiles = DiskQueueUtils.listSourceQueueFile((String)this.basePath);
        if (queueFiles == null) {
            return;
        }
        LOGGER.debug("the source cache file size---{}", (Object)queueFiles.size());
        for (File quefile : queueFiles) {
            try {
                Map mapObj = DiskQueueUtils.getQueueFile2Obj((File)quefile);
                for (Map.Entry entry : mapObj.entrySet()) {
                    String ehcachekey = (String)entry.getKey();
                    ComponentSourceDTO cachedComDTO = (ComponentSourceDTO)entry.getValue();
                    if (StringUtils.isEmpty((Object)cachedComDTO)) continue;
                    ComponentMessagesDTO sdto = new ComponentMessagesDTO();
                    BeanUtils.copyProperties((Object)cachedComDTO, (Object)sdto);
                    boolean updateFlag = this.sourceDao.updateToBundle(sdto);
                    if (updateFlag) continue;
                    throw new L10nAPIException("Failed to update source:" + ehcachekey);
                }
                this.processSendFilePath(this.basePath, quefile);
            }
            catch (L10nAPIException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                LOGGER.warn("The source cache file:{} will re-update to {}", (Object)quefile.getAbsolutePath(), (Object)this.activeDaoType);
                break;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                DiskQueueUtils.moveFile2ExceptPath((String)this.basePath, (File)quefile, (String)LOCAL_STR);
            }
        }
    }
}

