/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.source.service.impl;

import com.vmware.l10n.source.service.RemoteSyncService;
import com.vmware.l10n.source.service.SyncGrmSourceService;
import com.vmware.l10n.utils.DiskQueueUtils;
import com.vmware.vip.common.l10n.exception.L10nAPIException;
import com.vmware.vip.common.l10n.source.dto.ComponentSourceDTO;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SyncGrmSourceServiceImpl
implements SyncGrmSourceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncGrmSourceServiceImpl.class);
    private static final String LOCAL_STR = "local";
    private static final String GRM_STR = "grm";
    private static final long REQ_SPLIT_LIMIT = 0xA00000L;
    @Value(value="${source.bundle.file.basepath}")
    private String basePath;
    @Value(value="${grm.server.url}")
    private String remoteGRMURL;
    @Value(value="${vip.server.url}")
    private String remoteVIPURL;
    @Autowired
    private RemoteSyncService remoteSyncService;
    private boolean grmConnected = false;

    public synchronized void sendSourceToGRM() {
        if (LOCAL_STR.equalsIgnoreCase(this.remoteGRMURL)) {
            return;
        }
        try {
            this.remoteSyncService.ping(this.remoteGRMURL);
            this.setGrmConnected(true);
            this.processGRMQueueFiles();
        }
        catch (L10nAPIException e) {
            this.setGrmConnected(false);
            LOGGER.error("Remote [" + this.remoteGRMURL + "] is not connected.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void processGRMQueueFiles() throws IOException {
        List queueFiles = DiskQueueUtils.listQueueFiles((File)new File(this.basePath + DiskQueueUtils.L10N_TMP_GRM_PATH));
        if (queueFiles == null) {
            return;
        }
        LOGGER.debug("the GRM cache file size---{}", (Object)queueFiles.size());
        for (File quefile : queueFiles) {
            if (quefile.length() > 0xA00000L) {
                DiskQueueUtils.moveFile2ExceptPath((String)this.basePath, (File)quefile, (String)GRM_STR);
                continue;
            }
            try {
                Map mapObj = DiskQueueUtils.getQueueFile2Obj((File)quefile);
                for (Map.Entry entry : mapObj.entrySet()) {
                    ComponentSourceDTO cachedComDTO = (ComponentSourceDTO)entry.getValue();
                    this.sendData2GRM(cachedComDTO);
                }
                this.routeQueueFilePath(this.basePath, quefile);
            }
            catch (L10nAPIException e) {
                LOGGER.error("Send source file to GRM error:", (Throwable)e);
                break;
            }
        }
    }

    private void sendData2GRM(ComponentSourceDTO cachedComDTO) throws L10nAPIException {
        if (!StringUtils.isEmpty((Object)cachedComDTO) && this.isGrmConnected()) {
            this.remoteSyncService.send(cachedComDTO, this.remoteGRMURL);
        } else if (!this.isGrmConnected()) {
            throw new L10nAPIException("Remote [" + this.remoteGRMURL + "] is not connected.");
        }
    }

    private void routeQueueFilePath(String basePath, File source) throws IOException {
        if (this.remoteVIPURL.equalsIgnoreCase(LOCAL_STR)) {
            DiskQueueUtils.moveFile2IBackupPath((String)basePath, (File)source, (String)GRM_STR);
        } else {
            DiskQueueUtils.moveFile2I18nPath((String)basePath, (File)source);
        }
    }

    private boolean isGrmConnected() {
        return this.grmConnected;
    }

    private void setGrmConnected(boolean grmConnected) {
        this.grmConnected = grmConnected;
    }

    public String getBasePath() {
        return this.basePath;
    }
}

