/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.source.service.impl;

import com.vmware.l10n.source.service.SourceService;
import com.vmware.l10n.utils.DiskQueueUtils;
import com.vmware.l10n.utils.MapUtil;
import com.vmware.vip.common.l10n.source.dto.ComponentBaseDTO;
import com.vmware.vip.common.l10n.source.dto.ComponentSourceDTO;
import com.vmware.vip.common.l10n.source.dto.StringSourceDTO;
import com.vmware.vip.common.l10n.source.util.PathUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SourceServiceImpl
implements SourceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceService.class);
    private static final List<String> SOURSE_FORMATS = Arrays.asList("MD", "HTML");
    private static final BlockingQueue<StringSourceDTO> STRING_SOURCES = new LinkedBlockingQueue();
    private static final ConcurrentMap<String, ComponentSourceDTO> PREPARE_MAP = new ConcurrentHashMap();
    @Value(value="${source.bundle.file.basepath}")
    private String basePath;

    public boolean cacheSource(StringSourceDTO stringSourceDTO) {
        if (StringUtils.isEmpty((Object)stringSourceDTO) || StringUtils.isEmpty((Object)stringSourceDTO.getKey())) {
            return false;
        }
        try {
            STRING_SOURCES.put(stringSourceDTO);
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
        return true;
    }

    public void writeSourceToCachedFile() {
        int index = 1;
        LOGGER.debug("begin process queue's collection string to map ComponentSourceDTO ");
        while (!STRING_SOURCES.isEmpty()) {
            boolean flashFlag = this.mergeSource2Map();
            if (index % 512 == 0 || flashFlag) {
                this.cacheMapDTO((Map)PREPARE_MAP);
            }
            ++index;
        }
        if (!PREPARE_MAP.isEmpty()) {
            this.cacheMapDTO((Map)PREPARE_MAP);
        }
    }

    private boolean mergeSource2Map() {
        StringSourceDTO strDTO = (StringSourceDTO)STRING_SOURCES.poll();
        strDTO.setLocale("latest");
        String key = strDTO.getKey();
        String source = strDTO.getSource();
        String comment = strDTO.getComment();
        String sourceFormat = strDTO.getSourceFormat();
        String catcheKey = PathUtil.generateCacheKey((ComponentBaseDTO)strDTO);
        ComponentSourceDTO comp = (ComponentSourceDTO)PREPARE_MAP.get(catcheKey);
        if (StringUtils.isEmpty((Object)comp)) {
            this.addNewStringSource(strDTO, catcheKey, key, source, comment, sourceFormat);
        } else {
            this.updateStringSource(comp, key, source, comment, sourceFormat);
        }
        return SOURSE_FORMATS.contains(sourceFormat);
    }

    private void updateStringSource(ComponentSourceDTO comp, String key, String source, String comment, String sourceFormat) {
        MapUtil.updateKeyValue((Map)comp.getMessages(), (String)key, (Object)source);
        if (!StringUtils.isEmpty((Object)comment)) {
            comp.setComments(key, comment);
        }
        if (!StringUtils.isEmpty((Object)sourceFormat)) {
            comp.setSourceFormats(key, sourceFormat);
        }
    }

    private void addNewStringSource(StringSourceDTO strDTO, String catcheKey, String key, String source, String comment, String sourceFormat) {
        ComponentSourceDTO comp = new ComponentSourceDTO();
        BeanUtils.copyProperties((Object)strDTO, (Object)comp);
        comp.setMessages(key, source);
        if (!StringUtils.isEmpty((Object)comment)) {
            comp.setComments(key, comment);
        }
        if (!StringUtils.isEmpty((Object)sourceFormat)) {
            comp.setSourceFormats(key, sourceFormat);
        }
        PREPARE_MAP.put(catcheKey, comp);
    }

    private boolean cacheMapDTO(Map<String, ComponentSourceDTO> sources) {
        LOGGER.debug("begin process catcheMapDTO collection string to tem cache queue");
        try {
            File file = DiskQueueUtils.createQueueFile(sources, (String)this.basePath);
            if (file.exists()) {
                sources.clear();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }
}

