/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.source.dao.impl;

import com.vmware.l10n.conf.S3Client;
import com.vmware.l10n.source.dao.AllowListDao;
import com.vmware.l10n.utils.AllowListUtils;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Repository;

@Repository
@Profile(value={"s3"})
public class S3AllowListDaoImpl
implements AllowListDao {
    @Value(value="${allow.list.location:bundle.json}")
    protected String allowlistLocation;
    @Autowired
    public S3Client s3Client;

    private String readS3AllowlistFile() {
        if (this.s3Client.isObjectExist(this.allowlistLocation)) {
            return this.s3Client.readObject(this.allowlistLocation);
        }
        return "";
    }

    public Map<String, List<String>> getAllowList() {
        String jsonStr = this.readS3AllowlistFile();
        return AllowListUtils.parseAllowList((String)jsonStr);
    }
}

