/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.source.dao.impl;

import com.vmware.l10n.record.model.RecordModel;
import com.vmware.l10n.source.dao.SourceDao;
import com.vmware.l10n.utils.SourceUtils;
import com.vmware.vip.common.constants.ConstantsFile;
import com.vmware.vip.common.exceptions.VIPResourceOperationException;
import com.vmware.vip.common.i18n.dto.BaseDTO;
import com.vmware.vip.common.i18n.dto.SingleComponentDTO;
import com.vmware.vip.common.i18n.resourcefile.LocalJSONReader;
import com.vmware.vip.common.i18n.resourcefile.ResourceFilePathGetter;
import com.vmware.vip.common.l10n.exception.L10nAPIException;
import com.vmware.vip.common.l10n.source.dto.ComponentMessagesDTO;
import com.vmware.vip.common.utils.SortJSONUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
@Profile(value={"bundle"})
public class LocalSourceDaoImpl
implements SourceDao {
    private static Logger LOGGER = LoggerFactory.getLogger(LocalSourceDaoImpl.class);
    @Value(value="${source.bundle.file.basepath}")
    private String basepath;

    public String getFromBundle(SingleComponentDTO singleComponentDTO) {
        String result = "";
        String component = singleComponentDTO.getComponent();
        if (StringUtils.isEmpty((Object)component)) {
            component = "default";
            singleComponentDTO.setComponent(component);
        }
        String filepath = ConstantsFile.L10N_BUNDLES_PATH + ResourceFilePathGetter.getProductVersionConcatName((BaseDTO)singleComponentDTO) + "/" + component + "/" + ResourceFilePathGetter.getLocalizedJSONFileName((String)"latest");
        LOGGER.info("Read content from file: {}{}", (Object)this.basepath, (Object)filepath);
        if (new File(this.basepath + filepath).exists()) {
            result = new LocalJSONReader().readLocalJSONFile(this.basepath + filepath);
        }
        return result;
    }

    public boolean updateToBundle(ComponentMessagesDTO componentMessagesDTO) {
        LOGGER.info("[updateLocalTranslationToFile]");
        String component = componentMessagesDTO.getComponent();
        if (StringUtils.isEmpty((Object)component)) {
            component = "default";
            componentMessagesDTO.setComponent(component);
        }
        String filepath = ConstantsFile.L10N_BUNDLES_PATH + ResourceFilePathGetter.getProductVersionConcatName((BaseDTO)componentMessagesDTO) + "/" + component + "/" + ResourceFilePathGetter.getLocalizedJSONFileName((String)componentMessagesDTO.getLocale());
        LOGGER.info("Read content from file: {}{}", (Object)this.basepath, (Object)filepath);
        File targetFile = new File(this.basepath + filepath);
        if (targetFile.exists()) {
            LOGGER.info("The bunlde file path {}{} is found, update the bundle file.", (Object)this.basepath, (Object)filepath);
            try {
                String existingBundle = new LocalJSONReader().readLocalJSONFile(this.basepath + filepath);
                SingleComponentDTO latestDTO = SourceUtils.mergeCacheWithBundle((SingleComponentDTO)componentMessagesDTO, (String)existingBundle);
                SortJSONUtils.writeJSONObjectToJSONFile((String)(this.basepath + filepath), (SingleComponentDTO)latestDTO);
                return true;
            }
            catch (VIPResourceOperationException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        LOGGER.info("The bunlde file path {}{} is not found, cascade create the dir,add new bundle file ", (Object)this.basepath, (Object)filepath);
        try {
            FileUtils.write((File)targetFile, (CharSequence)"", (String)"UTF-8", (boolean)true);
            SortJSONUtils.writeJSONObjectToJSONFile((String)(this.basepath + filepath), (SingleComponentDTO)componentMessagesDTO);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public List<RecordModel> getUpdateRecords(String productName, String version, long lastModifyTime) throws L10nAPIException {
        String productParentDir = this.basepath + ConstantsFile.L10N_BUNDLES_PATH;
        StringBuilder prefix = new StringBuilder();
        prefix.append(productParentDir);
        if (!StringUtils.isEmpty((Object)productName)) {
            prefix.append(productName);
            prefix.append("/");
        }
        if (!StringUtils.isEmpty((Object)version)) {
            prefix.append(version);
            prefix.append("/");
        }
        File targetFile = new File(prefix.toString());
        LOGGER.info("local bundle file base path:{}", (Object)targetFile.getAbsolutePath());
        ArrayList<RecordModel> records = new ArrayList<RecordModel>();
        String latestJsonFile = "messages_latest.json";
        try (Stream<Path> sp = Files.walk(targetFile.toPath(), new FileVisitOption[0]);){
            sp.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.endsWith(latestJsonFile) && path.toFile().lastModified() > lastModifyTime).forEach(currPath -> {
                File file = currPath.toFile();
                LOGGER.info("Need Update:{}:{}", (Object)file.getAbsolutePath(), (Object)file.lastModified());
                records.add(SourceUtils.parseKeyStr2Record((String)file.getAbsolutePath(), (String)(new File(productParentDir).getAbsolutePath() + "/"), (long)file.lastModified()));
            });
        }
        catch (NoSuchFileException e1) {
            return records;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new L10nAPIException("Local disk bundle can't get update record!");
        }
        return records;
    }
}

