/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.source.dao.impl;

import com.vmware.l10n.source.dao.AllowListDao;
import com.vmware.l10n.utils.AllowListUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Repository;

@Repository
@Profile(value={"bundle"})
public class LocalAllowListDaoImpl
implements AllowListDao {
    @Value(value="${allow.list.location:bundle.json}")
    protected String allowlistLocation;

    public Map<String, List<String>> getAllowList() {
        String jsonStr = this.readAllowlistFile();
        return AllowListUtils.parseAllowList((String)jsonStr);
    }

    private String readAllowlistFile() {
        StringBuilder sb = new StringBuilder();
        File file = new File(this.allowlistLocation);
        InputStream inputStream = null;
        if (file.exists()) {
            try {
                inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else {
            inputStream = AllowListUtils.class.getClassLoader().getResourceAsStream("bundle.json");
        }
        try (BufferedReader inputReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
            String line = inputReader.readLine();
            while (null != line) {
                sb.append(line);
                line = inputReader.readLine();
            }
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        return sb.toString();
    }
}

