/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.source.controller;

import com.vmware.l10n.source.dto.SourceAPIResponseDTO;
import com.vmware.l10n.source.service.SourceService;
import com.vmware.l10n.utils.SourceUtils;
import com.vmware.vip.common.l10n.exception.L10nAPIException;
import com.vmware.vip.common.l10n.source.dto.StringSourceDTO;
import com.vmware.vip.common.utils.KeyUtils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="i10n-TranslationSourceAPI")
public class TranslationSourceAPI {
    private static Logger logger = LoggerFactory.getLogger(TranslationSourceAPI.class);
    @Autowired
    private SourceService sourceService;

    @Hidden
    @Operation(summary="Post the source", description="Post the source")
    @RequestMapping(value={"/i18n/l10n/api/v1/translation/product/{productName}/component/{component}/sources"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public SourceAPIResponseDTO postTranslationBySource(@PathVariable(value="productName") String productName, @RequestParam(value="version") String version, @PathVariable(value="component") String component, @RequestBody String source, @RequestParam(value="sourceFormat", required=false) String sourceFormat, @RequestParam(value="locale", required=false) String locale, @Parameter(name="collectSource", description="a flag to require backend collect the source for translation") @RequestParam(value="collectSource", required=true, defaultValue="true") String collectSource, HttpServletRequest request) throws L10nAPIException {
        String key = KeyUtils.generateKey((String)component, null, (String)source.toString());
        String newLocale = StringUtils.isEmpty((Object)locale) ? "en" : locale;
        StringSourceDTO sourceObj = SourceUtils.createSourceDTO((String)productName, (String)version, (String)component, (String)newLocale, (String)key, (String)source, null, (String)sourceFormat);
        logger.info("The parameters are: productName={}, version={}, component={}, locale={}, key={}, source={}", new Object[]{productName, version, component, newLocale, key, source});
        boolean isSourceCached = this.sourceService.cacheSource(sourceObj);
        return SourceUtils.handleSourceResponse((boolean)isSourceCached);
    }

    @Operation(summary="Post the source", description="Post the source")
    @RequestMapping(value={"/i18n/l10n/api/v2/translation/products/{productName}/versions/{version}/locales/{locale}/components/{component}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public SourceAPIResponseDTO createSource(@PathVariable(value="productName") String productName, @PathVariable(value="component") String component, @PathVariable(value="version") String version, @PathVariable(value="locale") String locale, @RequestBody String source, @RequestParam(value="sourceFormat", required=false) String sourceFormat, @Parameter(name="collectSource", description="a flag to require backend collect the source for translation") @RequestParam(value="collectSource", required=true, defaultValue="true") String collectSource, HttpServletRequest request) throws L10nAPIException {
        String key = KeyUtils.generateKey((String)component, null, (String)source.toString());
        String newLocale = StringUtils.isEmpty((Object)locale) ? "en" : locale;
        StringSourceDTO sourceObj = SourceUtils.createSourceDTO((String)productName, (String)version, (String)component, (String)newLocale, (String)key, (String)source, null, (String)sourceFormat);
        logger.info("The parameters are: productName={}, version={}, component={}, locale={}, key={}, source={}", new Object[]{productName, version, component, newLocale, key, source});
        boolean isSourceCached = this.sourceService.cacheSource(sourceObj);
        return SourceUtils.handleSourceResponse((boolean)isSourceCached);
    }
}

