/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.source.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.l10n.source.dto.SourceAPIResponseDTO;
import com.vmware.l10n.source.service.SourceService;
import com.vmware.vip.common.i18n.dto.KeySourceCommentDTO;
import com.vmware.vip.common.i18n.status.APIResponseStatus;
import com.vmware.vip.common.l10n.source.dto.StringSourceDTO;
import com.vmware.vip.common.utils.SourceFormatUtils;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Hidden
@RestController
public class SourceController {
    private static Logger LOGGER = LoggerFactory.getLogger(SourceController.class);
    @Autowired
    SourceService sourceService;

    @CrossOrigin
    @RequestMapping(value={"/l10n/api/v1/source/products/{productName}/components/{component}/keys/{key:.+}"}, produces={"application/json;charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.OK)
    public SourceAPIResponseDTO addStringForTranslation(@PathVariable(value="productName") String productName, @PathVariable(value="component") String component, @PathVariable(value="key") String key, @RequestParam(value="version", required=true) String version, @RequestParam(value="source", required=false) String source, @RequestParam(value="commentForSource", required=false) String commentForSource, @RequestParam(value="sourceFormat", required=false) String sourceFormat, HttpServletRequest req) throws Exception {
        source = source == null ? "" : source;
        LOGGER.info("The request url is: {}", (Object)req.getRequestURL());
        LOGGER.info("The parameters are: version=" + version + ", key=" + key + ", source=" + source + ", commentForSource=" + commentForSource);
        StringSourceDTO stringSourceDTO = this.createSourceDTO(productName, version, component, key, source, commentForSource, sourceFormat);
        boolean isSourceCached = this.sourceService.cacheSource(stringSourceDTO);
        SourceAPIResponseDTO sourceAPIResponseDTO = new SourceAPIResponseDTO();
        this.setResponseStatus(sourceAPIResponseDTO, isSourceCached);
        return sourceAPIResponseDTO;
    }

    @CrossOrigin
    @RequestMapping(value={"/l10n/api/v1/source/products/{productName}/components/{component}/keys/{key:.+}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.OK)
    public SourceAPIResponseDTO postSourceByKey(@PathVariable(value="productName") String productName, @PathVariable(value="component") String component, @PathVariable(value="key") String key, @RequestParam(value="version", required=true) String version, @RequestParam(value="source", required=false) String source, @RequestParam(value="commentForSource", required=false) String commentForSource, @RequestParam(value="sourceFormat", required=false) String sourceFormat, HttpServletRequest request) throws Exception {
        LOGGER.info("The request url is {}", (Object)request.getRequestURL());
        LOGGER.info(source);
        SourceAPIResponseDTO sourceAPIResponseDTO = new SourceAPIResponseDTO();
        String sourceStr = this.getSourceFromRequest(request);
        if (StringUtils.isEmpty((CharSequence)sourceStr)) {
            sourceStr = source;
        }
        boolean isSourceCached = true;
        JSONArray listKSC = null;
        if ("jsonkeyset".equalsIgnoreCase(key) && sourceStr.startsWith("[") && sourceStr.endsWith("]")) {
            listKSC = (JSONArray)JSONValue.parseWithException((String)sourceStr);
            ObjectMapper objectMapper = new ObjectMapper();
            for (Object kscObj : listKSC) {
                StringSourceDTO stringSourceDTO;
                KeySourceCommentDTO kscDTO = (KeySourceCommentDTO)objectMapper.readValue(kscObj.toString(), KeySourceCommentDTO.class);
                String k = kscDTO.getKey();
                String s = kscDTO.getSource();
                String c = kscDTO.getCommentForSource();
                String sf = kscDTO.getSourceFormat();
                if (!StringUtils.isEmpty((CharSequence)sf) && SourceFormatUtils.isBase64Encode((String)sf.toUpperCase())) {
                    s = SourceFormatUtils.decodeSourceBase64Str((String)s);
                    sf = SourceFormatUtils.formatSourceFormatStr((String)sf.toUpperCase());
                }
                if (this.sourceService.cacheSource(stringSourceDTO = this.createSourceDTO(productName, version, component, k, s, c, sf))) continue;
                isSourceCached = false;
            }
        } else {
            StringSourceDTO stringSourceDTO;
            LOGGER.info(key);
            if (!StringUtils.isEmpty((CharSequence)sourceFormat) && SourceFormatUtils.isBase64Encode((String)sourceFormat.toUpperCase())) {
                sourceStr = SourceFormatUtils.decodeSourceBase64Str((String)sourceStr);
                sourceFormat = SourceFormatUtils.formatSourceFormatStr((String)sourceFormat.toUpperCase());
            }
            if (!this.sourceService.cacheSource(stringSourceDTO = this.createSourceDTO(productName, version, component, key, sourceStr, commentForSource, sourceFormat))) {
                isSourceCached = false;
            }
        }
        this.setResponseStatus(sourceAPIResponseDTO, isSourceCached);
        return sourceAPIResponseDTO;
    }

    private StringSourceDTO createSourceDTO(String productName, String version, String component, String key, String source, String commentForSource, String sourceFormat) {
        StringSourceDTO stringSourceDTO = new StringSourceDTO();
        stringSourceDTO.setProductName(productName);
        stringSourceDTO.setComponent(component);
        stringSourceDTO.setVersion(version);
        stringSourceDTO.setKey(key);
        stringSourceDTO.setSource(source);
        stringSourceDTO.setComment(commentForSource);
        stringSourceDTO.setSourceFormat(sourceFormat);
        return stringSourceDTO;
    }

    private void setResponseStatus(SourceAPIResponseDTO sourceAPIResponseDTO, boolean isSourceCached) {
        if (isSourceCached) {
            sourceAPIResponseDTO.setResponse(APIResponseStatus.OK);
        } else {
            sourceAPIResponseDTO.setResponse(APIResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private String getSourceFromRequest(HttpServletRequest request) {
        String source = "";
        try {
            source = IOUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
            if (source == null || source.equals("{}")) {
                source = "";
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return source;
    }
}

