/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.record.controller;

import com.vmware.l10n.record.model.ComponentSourceModel;
import com.vmware.l10n.record.service.RecordService;
import com.vmware.vip.common.i18n.dto.response.APIResponseDTO;
import com.vmware.vip.common.i18n.status.APIResponseStatus;
import com.vmware.vip.common.l10n.exception.L10nAPIException;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RecordController {
    private Logger logger = LoggerFactory.getLogger(RecordController.class);
    @Autowired
    private RecordService recordService;
    private static final String LOGURLSTR = "The request url is {}";

    @GetMapping(value={"/i18n/l10n/api/v2/source/records"})
    public APIResponseDTO getRecordV2Model(@RequestParam(value="productName", required=false) String productName, @RequestParam(value="version", required=false) String version, @RequestParam(value="longDate", required=false) String longDate, HttpServletRequest request) throws L10nAPIException {
        this.logger.info("start getting the changed s3 record");
        this.logger.info(LOGURLSTR, (Object)request.getRequestURL());
        long lastModifyTime = 0L;
        try {
            lastModifyTime = Long.parseLong(longDate);
        }
        catch (Exception e) {
            this.logger.warn("parse lastModify error: {}", (Object)longDate);
        }
        this.logger.info("The parameters are: productName={}, version={},longDate={}", new Object[]{productName, version, longDate});
        List recordList = this.recordService.getChangedRecords(productName, version, lastModifyTime);
        this.logger.info("s3records size {}", (Object)recordList.size());
        APIResponseDTO responseDto = null;
        if (recordList != null && recordList.size() > 0) {
            responseDto = new APIResponseDTO();
            responseDto.setData((Object)recordList);
        } else {
            responseDto = new APIResponseDTO();
            responseDto.setResponse(APIResponseStatus.NO_CONTENT);
        }
        this.logger.info("end get the changed record V2 API");
        return responseDto;
    }

    @GetMapping(value={"/i18n/l10n/api/v1/source/sourcecomponent/{product}/{version}/{component}/{locale}/"})
    public APIResponseDTO getSourceComponentModel(@PathVariable String product, @PathVariable String version, @PathVariable String component, @PathVariable String locale, HttpServletRequest request) {
        APIResponseDTO responseDto = null;
        this.logger.info("begin get  component content");
        this.logger.info(LOGURLSTR, (Object)request.getRequestURL());
        this.logger.info("The parameters are: productName={}, version={}, component={}, locale={}", new Object[]{product, version, component, locale});
        ComponentSourceModel model = this.recordService.getComponentSource(product, version, component, locale);
        if (model != null) {
            responseDto = new APIResponseDTO();
            responseDto.setData((Object)model);
        } else {
            responseDto = new APIResponseDTO();
            responseDto.setResponse(APIResponseStatus.NO_CONTENT);
        }
        this.logger.info("end get component content");
        return responseDto;
    }
}

