/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.conf;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.GetBucketLocationRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.vmware.l10n.conf.S3Cfg;
import jakarta.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"s3"})
public class S3Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3Client.class);
    private static final int DURATIONSEC = 3600;
    private static final long TIME_ERR_RANGE = 3000L;
    private static long reducedTime;
    private static AmazonS3 s3Client;
    private static Credentials sessionCreds;
    @Autowired
    private S3Cfg config;

    @PostConstruct
    protected void initS3Client() {
        sessionCreds = this.getRoleCredentials();
        s3Client = this.getAmazonS3();
        if (!s3Client.doesBucketExistV2(this.config.getBucketName())) {
            s3Client.createBucket(this.config.getBucketName());
            String bucketLocation = s3Client.getBucketLocation(new GetBucketLocationRequest(this.config.getBucketName()));
            if (StringUtils.isEmpty((CharSequence)bucketLocation)) {
                LOGGER.error("create new bucket failure: {}", (Object)this.config.getBucketName());
            } else {
                LOGGER.info("create new bucket location: {}", (Object)bucketLocation);
            }
        }
    }

    public synchronized AmazonS3 getS3Client() {
        if (sessionCreds.getExpiration().getTime() - System.currentTimeMillis() > reducedTime) {
            return s3Client;
        }
        sessionCreds = this.getRoleCredentials();
        s3Client = this.getAmazonS3();
        return s3Client;
    }

    private synchronized Credentials getRoleCredentials() {
        AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.config.getAccessKey(), this.config.getSecretkey()));
        AWSSecurityTokenService stsClient = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).withRegion(this.config.getS3Region())).build();
        AssumeRoleRequest arreq = new AssumeRoleRequest();
        arreq.setDurationSeconds(Integer.valueOf(3600));
        arreq.setRoleArn(this.config.getRoleArn());
        arreq.setRoleSessionName("SingletonRoleSession");
        AssumeRoleResult sessionTokenResult = stsClient.assumeRole(arreq);
        long time = System.currentTimeMillis();
        Credentials result = sessionTokenResult.getCredentials();
        reducedTime = result.getExpiration().getTime() - 3600000L - time + 3000L;
        return result;
    }

    private synchronized AmazonS3 getAmazonS3() {
        BasicSessionCredentials sessionCredentials = new BasicSessionCredentials(sessionCreds.getAccessKeyId(), sessionCreds.getSecretAccessKey(), sessionCreds.getSessionToken());
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)sessionCredentials))).withRegion(this.config.getS3Region())).enablePathStyleAccess()).build();
    }

    public String readObject(String key) {
        return this.getS3Client().getObjectAsString(this.config.getBucketName(), this.normalizePath(key));
    }

    public PutObjectResult putObject(String key, String content) {
        return this.getS3Client().putObject(this.config.getBucketName(), this.normalizePath(key), content);
    }

    public void deleteObject(String key) {
        this.getS3Client().deleteObject(this.config.getBucketName(), this.normalizePath(key));
    }

    public boolean isObjectExist(String key) {
        return this.getS3Client().doesObjectExist(this.config.getBucketName(), this.normalizePath(key));
    }

    public String normalizePath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }
}

