/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.conf;

import com.vmware.vip.common.utils.RsaCryptUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
@Profile(value={"s3"})
public class S3Cfg {
    private static Logger logger = LoggerFactory.getLogger(S3Cfg.class);
    @Value(value="${s3.keysEncryptEnable:false}")
    private Boolean encryption;
    @Value(value="${s3.publicKey}")
    private String publicKey;
    @Value(value="${s3.accessKey}")
    private String accessKey;
    @Value(value="${s3.secretkey}")
    private String secretkey;
    @Value(value="${s3.region}")
    private String s3Region;
    @Value(value="${s3.bucketName}")
    private String bucketName;
    @Value(value="${s3.roleArn}")
    private String roleArn;

    public String getAccessKey() {
        if (this.encryption.booleanValue()) {
            try {
                logger.debug("accessKey: {}", (Object)this.accessKey);
                return RsaCryptUtils.decryptData((String)this.accessKey, (String)this.getPublicKey());
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretkey() {
        if (this.encryption.booleanValue()) {
            try {
                logger.debug("secretkey: {}", (Object)this.secretkey);
                return RsaCryptUtils.decryptData((String)this.secretkey, (String)this.getPublicKey());
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return this.secretkey;
    }

    public void setSecretkey(String secretkey) {
        this.secretkey = secretkey;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getS3Region() {
        return this.s3Region;
    }

    public void setS3Region(String s3Region) {
        this.s3Region = s3Region;
    }

    public Boolean isEncryption() {
        return this.encryption;
    }

    public void setEncryption(Boolean encryption) {
        this.encryption = encryption;
    }

    public String getPublicKey() {
        try {
            if (this.publicKey.startsWith("classpath:") || this.publicKey.startsWith("file:")) {
                Resource resource = new PathMatchingResourcePatternResolver().getResource(this.publicKey);
                String content = RsaCryptUtils.getPublicKeyStrFromInputStream((InputStream)resource.getInputStream());
                logger.debug("public key: {}", (Object)content);
                return content;
            }
            File file = new File(this.publicKey);
            if (file.exists()) {
                String content = null;
                content = RsaCryptUtils.getPublicKeyStrFromInputStream((InputStream)new FileInputStream(file));
                logger.debug("public key: {}", (Object)content);
                return content;
            }
            logger.error("not found public key file: {}", (Object)file.getAbsoluteFile());
            return null;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getRoleArn() {
        return this.roleArn;
    }
}

