/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.conf;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.vmware.vip.common.csp.Claim;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CspValidateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CspValidateService.class);
    @Value(value="${csp.auth.issuer:###}")
    private String issuer;
    @Value(value="${csp.auth.url:###}")
    private String jwksUri;
    @Value(value="${csp.auth.refresh-interval-sec:30}")
    private int refreshIntervalSec;
    private Instant keyRotateEndpointLastAccess;
    private URL url;
    private JWKSet jwksInMem;

    public boolean isTokenValid(String token) {
        return this.getTokenClaims(token) != null;
    }

    public Claim getTokenClaims(String token) {
        if (this.jwksInMem == null || this.jwksInMem.getKeys() == null) {
            this.callCspJwksEndpoint();
        }
        try {
            return this.validate(token);
        }
        catch (BadJWTException e) {
            LOGGER.error("Token is not valid", (Throwable)e);
        }
        catch (BadJOSEException e) {
            LOGGER.error("Bad JSON Object Signing and Encryption found", (Throwable)e);
        }
        catch (ParseException e) {
            LOGGER.error("Error while parsing token string", (Throwable)e);
        }
        catch (JOSEException e) {
            LOGGER.error("Internal processing of token failed", (Throwable)e);
        }
        return null;
    }

    private Claim validate(String token) throws ParseException, BadJOSEException, JOSEException {
        if (token == null) {
            return null;
        }
        SignedJWT signedJWT = SignedJWT.parse((String)token);
        String tokenKid = signedJWT.getHeader().getKeyID();
        JWK matchKey = null;
        for (JWK key : this.jwksInMem.getKeys()) {
            if (!key.getKeyID().equals(tokenKid)) continue;
            matchKey = key;
            break;
        }
        if (matchKey == null && !this.allowRefreshJwkset(this.getRefreshIntervalSec())) {
            LOGGER.info("Trying to hit public key endpoint within {} sec, possibly a DoS (Denial of Service) attack", (Object)this.getRefreshIntervalSec());
        }
        if (matchKey == null) {
            return null;
        }
        JWSAlgorithm alg = this.getKeyAlg(matchKey);
        DefaultResourceRetriever resourceRetriever = new DefaultResourceRetriever(2000, 2000);
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        RemoteJWKSet keySource = new RemoteJWKSet(this.url, (ResourceRetriever)resourceRetriever);
        JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(alg, (JWKSource)keySource);
        jwtProcessor.setJWSKeySelector((JWSKeySelector)keySelector);
        SecurityContext ctx = null;
        JWTClaimsSet claimSet = jwtProcessor.process(token, ctx);
        jwtProcessor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)new /* Unavailable Anonymous Inner Class!! */);
        jwtProcessor.getJWTClaimsSetVerifier().verify(claimSet, ctx);
        Claim claim = new Claim();
        claim.setSub(claimSet.getClaim("sub").toString());
        claim.setExp(claimSet.getClaim("exp").toString());
        claim.setIat(claimSet.getClaim("iat").toString());
        claim.setContextName(claimSet.getClaim("context_name").toString());
        if (claimSet.getClaim("acct") != null) {
            claim.setAcct(claimSet.getClaim("acct").toString());
        }
        if (claimSet.getClaim("domain") != null) {
            claim.setDomain(claimSet.getClaim("domain").toString());
        }
        if (claimSet.getClaim("context") != null) {
            claim.setContext(claimSet.getClaim("context").toString());
        }
        if (claimSet.getStringArrayClaim("perms") != null) {
            claim.setPerms(claimSet.getStringArrayClaim("perms"));
        }
        return claim;
    }

    private JWSAlgorithm getKeyAlg(JWK key) throws BadJOSEException {
        if (key.getKeyType().toString().equals("RSA")) {
            return JWSAlgorithm.RS256;
        }
        throw new BadJOSEException("Unsupported algorithm by CSP");
    }

    private synchronized void callCspJwksEndpoint() {
        try {
            this.url = new URL(this.getJwksUri());
            this.jwksInMem = JWKSet.load((URL)this.url);
            this.keyRotateEndpointLastAccess = Instant.now();
        }
        catch (MalformedURLException e) {
            LOGGER.error("End Point URL not proper", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("IO issue", (Throwable)e);
        }
        catch (ParseException e) {
            LOGGER.error("JSON KeySet is not proper, could not parse", (Throwable)e);
        }
    }

    private synchronized boolean allowRefreshJwkset(int elapsed) {
        if (Instant.now().compareTo(this.keyRotateEndpointLastAccess.plusSeconds(elapsed)) > 0) {
            this.callCspJwksEndpoint();
            return true;
        }
        return false;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public int getRefreshIntervalSec() {
        return this.refreshIntervalSec;
    }
}

