/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.conf;

import com.vmware.l10n.conf.CspValidateService;
import com.vmware.vip.common.i18n.status.Response;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerInterceptor;

public class CspAuthInterceptor
implements HandlerInterceptor {
    private static Logger logger = LoggerFactory.getLogger(CspAuthInterceptor.class);
    private final CspValidateService cspValidateService;

    public CspAuthInterceptor(CspValidateService cspValidateService) {
        this.cspValidateService = cspValidateService;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String token = request.getHeader("csp-auth-token");
        if (token == null) {
            response.setContentType("application/json;charset=utf-8");
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            response.getWriter().write(this.buildRespBody(HttpStatus.UNAUTHORIZED.value(), "Token validation failed"));
            return false;
        }
        if (!this.cspValidateService.isTokenValid(token)) {
            response.setContentType("application/json;charset=utf-8");
            response.setStatus(HttpStatus.FORBIDDEN.value());
            response.getWriter().write(this.buildRespBody(HttpStatus.FORBIDDEN.value(), "Invalid token"));
            return false;
        }
        return true;
    }

    private String buildRespBody(int code, String msg) {
        Response resp = new Response();
        resp.setCode(Integer.valueOf(code));
        resp.setMessage(msg);
        resp.setServerTime(LocalDateTime.now().toString());
        String responseBody = resp.toJSONString();
        if (logger.isDebugEnabled()) {
            logger.debug(responseBody);
        }
        String rstr = "[response] " + responseBody;
        logger.info(rstr);
        String endHandle = "[thread-" + Thread.currentThread().getId() + "] End to handle request.";
        logger.info(endHandle);
        return responseBody;
    }
}

