/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.conf;

import com.vmware.vip.common.constants.ConstantsKeys;
import com.vmware.vip.common.exceptions.ValidationException;
import com.vmware.vip.common.utils.RegExpValidatorUtils;
import com.vmware.vip.common.utils.SourceFormatUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;

/*
 * Exception performing whole class analysis ignored.
 */
public class CollectSourceValidationInterceptor
implements HandlerInterceptor {
    private static Logger LOGGER = LoggerFactory.getLogger(CollectSourceValidationInterceptor.class);
    private Map<String, List<String>> allowList;
    private List<String> clientRequestIds;

    public CollectSourceValidationInterceptor(Map<String, List<String>> allowListMap, String clientReqIdsStr) {
        try {
            this.clientRequestIds = Arrays.asList(clientReqIdsStr.split(","));
        }
        catch (Exception e) {
            this.clientRequestIds = null;
        }
        this.allowList = allowListMap;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String singletonRequestID = this.getRequestId(request, this.clientRequestIds);
        String logOfUrl = singletonRequestID + "The request url is: " + request.getRequestURL();
        String logOfQueryStr = singletonRequestID + "The request query string is: " + request.getQueryString();
        CollectSourceValidationInterceptor.validate((HttpServletRequest)request, (Map)this.allowList);
        String startHandle = singletonRequestID + "[thread-" + Thread.currentThread().getId() + "] Start to handle request...";
        LOGGER.info(startHandle);
        LOGGER.info(logOfUrl);
        LOGGER.info(logOfQueryStr);
        return true;
    }

    private static void validate(HttpServletRequest request, Map<String, List<String>> allowList) throws ValidationException {
        if (request == null) {
            return;
        }
        CollectSourceValidationInterceptor.validateAllowList((HttpServletRequest)request, allowList);
        CollectSourceValidationInterceptor.validateProductname((HttpServletRequest)request);
        CollectSourceValidationInterceptor.validateVersion((HttpServletRequest)request);
        CollectSourceValidationInterceptor.validateComponent((HttpServletRequest)request);
        CollectSourceValidationInterceptor.validateKey((HttpServletRequest)request);
        CollectSourceValidationInterceptor.validateLocale((HttpServletRequest)request);
        CollectSourceValidationInterceptor.validateSourceformat((HttpServletRequest)request);
        CollectSourceValidationInterceptor.validateCollectsource((HttpServletRequest)request);
        CollectSourceValidationInterceptor.validatePseudo((HttpServletRequest)request);
    }

    private static void validateProductname(HttpServletRequest request) throws ValidationException {
        String productName;
        Map pathVariables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        String string = productName = pathVariables.get("productName") == null ? request.getParameter("productName") : (String)pathVariables.get("productName");
        if (StringUtils.isEmpty((CharSequence)productName)) {
            return;
        }
        if (!RegExpValidatorUtils.IsLetterOrNumber((String)productName)) {
            throw new ValidationException("Incorrect produtName(only allows letter and number)");
        }
    }

    private static void validateVersion(HttpServletRequest request) throws ValidationException {
        String version;
        Map pathVariables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        String string = version = pathVariables.get("version") == null ? request.getParameter("version") : (String)pathVariables.get("version");
        if (StringUtils.isEmpty((CharSequence)version)) {
            return;
        }
        if (!RegExpValidatorUtils.IsNumberAndDot((String)version)) {
            throw new ValidationException("Incorrect version(only allows number and dot, e.g. 1.2.0)");
        }
    }

    private static void validateComponent(HttpServletRequest request) throws ValidationException {
        String component;
        Map pathVariables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        String string = component = pathVariables.get("component") == null ? request.getParameter("component") : (String)pathVariables.get("component");
        if (StringUtils.isEmpty((CharSequence)component)) {
            return;
        }
        if (!RegExpValidatorUtils.IsLetterAndNumberAndValidchar((String)component)) {
            throw new ValidationException("Incorrect component(only allows letter, number, dot, underline, dashline)");
        }
    }

    private static void validateKey(HttpServletRequest request) throws ValidationException {
        String key;
        Map pathVariables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        String string = key = pathVariables.get("key") == null ? request.getParameter("key") : (String)pathVariables.get("key");
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        if (!RegExpValidatorUtils.isAscii((String)key)) {
            throw new ValidationException(String.format("Incorrect key name '%s' contains non-ASCII char(only allows standard ASCII char)", key));
        }
    }

    private static void validateLocale(HttpServletRequest request) throws ValidationException {
        String locale;
        Map pathVariables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        String string = locale = pathVariables.get("locale") == null ? request.getParameter("locale") : (String)pathVariables.get("locale");
        if (StringUtils.isEmpty((CharSequence)locale)) {
            return;
        }
        if (!RegExpValidatorUtils.IsLetterAndNumberAndValidchar((String)locale)) {
            throw new ValidationException("Incorrect locale(only allows letter, number, dot, underline, dashline)");
        }
    }

    public static void validateSourceformat(HttpServletRequest request) throws ValidationException {
        String sourceFormat;
        String string = sourceFormat = request.getParameter("sourceFormat") == null ? "" : request.getParameter("sourceFormat");
        if (!StringUtils.isEmpty((CharSequence)sourceFormat) && (SourceFormatUtils.isBase64Encode((String)(sourceFormat = sourceFormat.toUpperCase())) ? !StringUtils.isEmpty((CharSequence)(sourceFormat = SourceFormatUtils.formatSourceFormatStr((String)sourceFormat))) && !ConstantsKeys.SOURCE_FORMAT_LIST.contains(sourceFormat) : !ConstantsKeys.SOURCE_FORMAT_LIST.contains(sourceFormat))) {
            throw new ValidationException("Incorrect sourceformat(only allows empty, STRING, MD, HTML, SVG, BASE64)");
        }
    }

    private static void validateCollectsource(HttpServletRequest request) throws ValidationException {
        String collectSource;
        String string = collectSource = request.getParameter("collectSource") == null ? "" : request.getParameter("collectSource");
        if (StringUtils.isEmpty((CharSequence)collectSource)) {
            return;
        }
        if (!RegExpValidatorUtils.IsTrueOrFalse((String)collectSource) || collectSource.equalsIgnoreCase("false")) {
            throw new ValidationException("Incorrect collectSource(only allows true, please use translation-product-component-api to confirm received source status)");
        }
    }

    private static void validatePseudo(HttpServletRequest request) throws ValidationException {
        String pseudo;
        String string = pseudo = request.getParameter("pseudo") == null ? "" : request.getParameter("pseudo");
        if (StringUtils.isEmpty((CharSequence)pseudo)) {
            return;
        }
        if (!RegExpValidatorUtils.IsTrueOrFalse((String)pseudo)) {
            throw new ValidationException("Incorrect pseudo(only allows true, false)");
        }
    }

    private static void validateAllowList(HttpServletRequest request, Map<String, List<String>> allowList) throws ValidationException {
        String version;
        Map pathVariables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        String productName = pathVariables.get("productName") == null ? request.getParameter("productName") : (String)pathVariables.get("productName");
        String string = version = pathVariables.get("version") == null ? request.getParameter("version") : (String)pathVariables.get("version");
        if (StringUtils.isEmpty((CharSequence)productName) || StringUtils.isEmpty((CharSequence)version)) {
            return;
        }
        if (allowList != null && allowList.containsKey(productName) && (allowList.get(productName).contains("*") || allowList.get(productName).contains(version))) {
            return;
        }
        throw new ValidationException(String.format("The product '%s' is NOT supported yet!", productName));
    }

    private String getRequestId(HttpServletRequest request, List<String> headerNames) {
        StringBuilder singletonReqIds = new StringBuilder("");
        if (headerNames != null) {
            for (String headerName : headerNames) {
                String reqIdStr = request.getHeader(headerName);
                if (StringUtils.isEmpty((CharSequence)reqIdStr)) continue;
                singletonReqIds.append("[clientRequestHeader- ").append(headerName).append(": ").append(reqIdStr).append("] ");
            }
        }
        return singletonReqIds.toString();
    }
}

