/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.Escaping;
import com.vladsch.flexmark.util.mappers.CharMapper;
import com.vladsch.flexmark.util.mappers.LowerCaseMapper;
import com.vladsch.flexmark.util.mappers.UpperCaseMapper;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.MappedSequence;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import com.vladsch.flexmark.util.sequence.SubSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class BasedSequenceImpl
implements BasedSequence {
    public static final String WHITESPACE_NO_EOL_CHARS = " \t";
    public static final String WHITESPACE_CHARS = " \t\r\n";
    public static final String WHITESPACE_NBSP_CHARS = " \t\r\n\u00a0";
    public static final String EOL_CHARS = "\r\n";
    public static final Map<Character, String> visibleSpacesMap;

    @Override
    public BasedSequence endSequence(int start, int end) {
        int length = this.length();
        int useStart = length - start;
        int useEnd = length - end;
        if (useStart < 0) {
            useStart = 0;
        } else if (useStart > length) {
            useStart = length;
        }
        if (useEnd < 0) {
            useEnd = 0;
        } else if (useEnd > length) {
            useEnd = length;
        }
        if (useStart > useEnd) {
            useStart = useEnd;
        }
        if (useStart == 0 && useEnd == length) {
            return this;
        }
        return this.subSequence(useStart, useEnd);
    }

    @Override
    public BasedSequence endSequence(int start) {
        int length = this.length();
        if (start <= 0) {
            return this.subSequence(length, length);
        }
        if (start >= length) {
            return this;
        }
        return this.subSequence(length - start, length);
    }

    @Override
    public char endCharAt(int index) {
        if (index < 0 || index >= this.length()) {
            return '\u0000';
        }
        return this.charAt(this.length() - index);
    }

    @Override
    public BasedSequence midSequence(int start, int end) {
        int useEnd;
        int length = this.length();
        int useStart = start < 0 ? length + start : start;
        int n = useEnd = end < 0 ? length + end : end;
        if (useStart < 0) {
            useStart = 0;
        } else if (useStart > length) {
            useStart = length;
        }
        if (useEnd < 0) {
            useEnd = 0;
        } else if (useEnd > length) {
            useEnd = length;
        }
        if (useStart > useEnd) {
            useStart = useEnd;
        }
        if (useStart == 0 && useEnd == length) {
            return this;
        }
        return this.subSequence(useStart, useEnd);
    }

    @Override
    public BasedSequence midSequence(int start) {
        int useStart;
        int length = this.length();
        int n = useStart = start < 0 ? length + start : start;
        if (useStart <= 0) {
            return this;
        }
        if (useStart >= length) {
            return this.subSequence(length, length);
        }
        return this.subSequence(useStart, length);
    }

    @Override
    public char midCharAt(int index) {
        if (index < -this.length() || index >= this.length()) {
            return '\u0000';
        }
        return this.charAt(index < 0 ? this.length() + index : index);
    }

    @Override
    public int countLeading(String chars) {
        return this.countChars(chars, 0, this.length());
    }

    @Override
    public int countLeadingNot(String chars) {
        return this.countNotChars(chars, 0, this.length());
    }

    @Override
    public int countTrailing(String chars) {
        return this.countCharsReversed(chars, 0, this.length());
    }

    @Override
    public int countTrailingNot(String chars) {
        return this.countNotCharsReversed(chars, 0, this.length());
    }

    @Override
    public BasedSequence trimStart(String chars) {
        int trim = this.countChars(chars, 0, this.length());
        return trim > 0 ? this.subSequence(trim, this.length()) : this;
    }

    @Override
    public BasedSequence trimmedStart(String chars) {
        int trim = this.countChars(chars, 0, this.length());
        return trim > 0 ? this.subSequence(0, trim) : SubSequence.NULL;
    }

    @Override
    public BasedSequence trimEnd(String chars) {
        int trim = this.countCharsReversed(chars, 0, this.length());
        return trim > 0 ? this.subSequence(0, this.length() - trim) : this;
    }

    @Override
    public BasedSequence trimmedEnd(String chars) {
        int trim = this.countCharsReversed(chars, 0, this.length());
        return trim > 0 ? this.subSequence(this.length() - trim) : SubSequence.NULL;
    }

    @Override
    public BasedSequence trim(String chars) {
        int trimEnd;
        int trimStart = this.countChars(chars, 0, this.length());
        int trimmed = trimStart + (trimEnd = this.countCharsReversed(chars, 0, this.length()));
        return trimmed > 0 ? (trimmed >= this.length() ? this.subSequence(0, 0) : this.subSequence(trimStart, this.length() - trimEnd)) : this;
    }

    @Override
    public BasedSequence trimStart() {
        int trim = this.countChars(WHITESPACE_CHARS, 0, this.length());
        return trim > 0 ? this.subSequence(trim, this.length()) : this;
    }

    @Override
    public BasedSequence trimmedStart() {
        int trim = this.countChars(WHITESPACE_CHARS, 0, this.length());
        return trim > 0 ? this.subSequence(0, trim) : SubSequence.NULL;
    }

    @Override
    public BasedSequence trimEnd() {
        int trim = this.countCharsReversed(WHITESPACE_CHARS, 0, this.length());
        return trim > 0 ? this.subSequence(0, this.length() - trim) : this;
    }

    @Override
    public BasedSequence trimmedEnd() {
        int trim = this.countCharsReversed(WHITESPACE_CHARS, 0, this.length());
        return trim > 0 ? this.subSequence(this.length() - trim) : SubSequence.NULL;
    }

    @Override
    public int eolLength() {
        return this.countCharsReversed(EOL_CHARS, 0, this.length());
    }

    @Override
    public BasedSequence trimEOL() {
        int trim = this.eolLength();
        return trim > 0 ? this.subSequence(0, this.length() - trim) : this;
    }

    @Override
    public BasedSequence trimmedEOL() {
        int trim = this.eolLength();
        return trim > 0 ? this.subSequence(this.length() - trim) : SubSequence.NULL;
    }

    @Override
    public BasedSequence trim() {
        int trimStart = this.countChars(WHITESPACE_CHARS, 0, this.length());
        if (trimStart == this.length()) {
            return this.subSequence(trimStart, trimStart);
        }
        int trimEnd = this.countCharsReversed(WHITESPACE_CHARS, 0, this.length());
        return trimStart > 0 || trimEnd > 0 ? this.subSequence(trimStart, this.length() - trimEnd) : this;
    }

    @Override
    public BasedSequence ifNullEmptyAfter(BasedSequence other) {
        return this.isNull() ? other.subSequence(other.length(), other.length()) : this;
    }

    @Override
    public BasedSequence ifNullEmptyBefore(BasedSequence other) {
        return this.isNull() ? other.subSequence(0, 0) : this;
    }

    @Override
    public BasedSequence nullIfEmpty() {
        return this.isEmpty() ? SubSequence.NULL : this;
    }

    @Override
    public BasedSequence nullIfBlank() {
        return this.isBlank() ? SubSequence.NULL : this;
    }

    @Override
    public BasedSequence nullIf(boolean condition) {
        return condition ? SubSequence.NULL : this;
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public boolean isBlank() {
        int trim = this.countChars(WHITESPACE_CHARS, 0, this.length());
        return trim == this.length();
    }

    @Override
    public boolean isNull() {
        return this == SubSequence.NULL;
    }

    @Override
    public boolean isNotNull() {
        return this != SubSequence.NULL;
    }

    @Override
    public boolean endsWith(String suffix) {
        return this.length() > 0 && this.matchCharsReversed(suffix, this.length());
    }

    @Override
    public boolean startsWith(String prefix) {
        return this.length() > 0 && this.matchChars(prefix, 0);
    }

    @Override
    public MappedSequence toLowerCase() {
        return this.toMapped(LowerCaseMapper.INSTANCE);
    }

    @Override
    public MappedSequence toUpperCase() {
        return this.toMapped(UpperCaseMapper.INSTANCE);
    }

    @Override
    public MappedSequence toLowerCase(Locale locale) {
        return this.toMapped(new LowerCaseMapper(locale));
    }

    @Override
    public MappedSequence toUpperCase(Locale locale) {
        return this.toMapped(new UpperCaseMapper(locale));
    }

    @Override
    public final MappedSequence toMapped(CharMapper mapper) {
        return new MappedSequence((CharSequence)this, mapper);
    }

    private static boolean contains(String chars, char c) {
        int iMax = chars.length();
        for (int i = 0; i < iMax; ++i) {
            if (chars.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(String chars) {
        return chars.length() == this.length() && this.matchChars(chars);
    }

    @Override
    public boolean matchChars(String chars) {
        return this.matchChars(chars, 0);
    }

    @Override
    public boolean matchChars(String chars, int startIndex) {
        int iMax = chars.length();
        if (iMax > this.length() - startIndex) {
            return false;
        }
        for (int i = 0; i < iMax; ++i) {
            if (chars.charAt(i) == this.charAt(i + startIndex)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matchCharsReversed(String chars, int endIndex) {
        return endIndex >= chars.length() && this.matchChars(chars, endIndex - chars.length());
    }

    @Override
    public int countChars(String chars, int startIndex, int endIndex) {
        int count = 0;
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        for (int i = startIndex; i < endIndex && BasedSequenceImpl.contains(chars, this.charAt(i)); ++i) {
            ++count;
        }
        return count;
    }

    @Override
    public int countCharsReversed(String chars, int startIndex, int endIndex) {
        int count = 0;
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        int i = endIndex;
        while (i-- > startIndex && BasedSequenceImpl.contains(chars, this.charAt(i))) {
            ++count;
        }
        return count;
    }

    @Override
    public int countNotChars(String chars, int startIndex, int endIndex) {
        int count = 0;
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        for (int i = startIndex; i < endIndex && !BasedSequenceImpl.contains(chars, this.charAt(i)); ++i) {
            ++count;
        }
        return count;
    }

    @Override
    public int countNotCharsReversed(String chars, int startIndex, int endIndex) {
        int count = 0;
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        int i = endIndex;
        while (i-- > startIndex && !BasedSequenceImpl.contains(chars, this.charAt(i))) {
            ++count;
        }
        return count;
    }

    @Override
    public int countChars(String chars) {
        return this.countChars(chars, 0, this.length());
    }

    @Override
    public int countCharsReversed(String chars) {
        return this.countCharsReversed(chars, 0, this.length());
    }

    @Override
    public int countNotChars(String chars) {
        return this.countNotChars(chars, 0, this.length());
    }

    @Override
    public int countNotCharsReversed(String chars) {
        return this.countNotCharsReversed(chars, 0, this.length());
    }

    @Override
    public BasedSequence subSequence(Range range) {
        return this.subSequence(range.getStart(), range.getEnd());
    }

    @Override
    public BasedSequence subSequence(int start) {
        return this.subSequence(start, this.length());
    }

    @Override
    public BasedSequence trimTailBlankLines() {
        int iMax;
        int lastEOL = iMax = this.length();
        int i = iMax;
        while (i-- > 0) {
            char c = this.charAt(i);
            if (c == '\n') {
                lastEOL = i + 1;
                continue;
            }
            if (lastEOL != iMax && (c == ' ' || c == '\t')) continue;
            break;
        }
        if (i < 0) {
            return this.subSequence(0, 0);
        }
        if (lastEOL != iMax) {
            return this.subSequence(0, lastEOL);
        }
        return this;
    }

    @Override
    public BasedSequence trimLeadBlankLines() {
        int i;
        int iMax = this.length();
        int lastEOL = 0;
        for (i = 0; i < iMax; ++i) {
            char c = this.charAt(i);
            if (c == '\n') {
                lastEOL = i + 1;
                continue;
            }
            if (c != ' ' && c != '\t') break;
        }
        if (i == iMax) {
            return this.subSequence(iMax, iMax);
        }
        if (lastEOL != 0) {
            return this.subSequence(lastEOL);
        }
        return this;
    }

    @Override
    public String toString() {
        int iMax = this.length();
        StringBuilder sb = new StringBuilder(iMax);
        for (int i = 0; i < iMax; ++i) {
            sb.append(this.charAt(i));
        }
        return sb.toString();
    }

    @Override
    public String unescape() {
        return Escaping.unescapeString(this.toString());
    }

    @Override
    public BasedSequence unescape(ReplacedTextMapper textMapper) {
        return Escaping.unescape(this, textMapper);
    }

    @Override
    public String normalizeEOL() {
        return Escaping.normalizeEOL(this.toString());
    }

    @Override
    public BasedSequence normalizeEOL(ReplacedTextMapper textMapper) {
        return Escaping.normalizeEOL(this, textMapper);
    }

    @Override
    public String normalizeEndWithEOL() {
        return Escaping.normalizeEndWithEOL(this.toString());
    }

    @Override
    public BasedSequence normalizeEndWithEOL(ReplacedTextMapper textMapper) {
        return Escaping.normalizeEndWithEOL(this, textMapper);
    }

    @Override
    public int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    @Override
    public int lastIndexOf(char c) {
        return this.lastIndexOf(c, this.length());
    }

    @Override
    public int indexOf(String s) {
        return this.indexOf(s, 0);
    }

    @Override
    public int lastIndexOf(String s) {
        return this.lastIndexOf(s, this.length());
    }

    @Override
    public int indexOf(char c, int index) {
        int iMax = this.length();
        for (int i = index; i < iMax; ++i) {
            if (this.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexOfAny(char c1, char c2) {
        return this.indexOfAny(c1, c2, 0);
    }

    @Override
    public int indexOfAny(char c1, char c2, int index) {
        int iMax = this.length();
        for (int i = index; i < iMax; ++i) {
            char c = this.charAt(i);
            if (c != c1 && c != c2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexOfAny(char c1, char c2, char c3) {
        return this.indexOfAny(c1, c2, c3, 0);
    }

    @Override
    public int indexOfAny(char c1, char c2, char c3, int index) {
        int iMax = this.length();
        for (int i = index; i < iMax; ++i) {
            char c = this.charAt(i);
            if (c != c1 && c != c2 && c != c3) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(char c, int index) {
        int i = index;
        while (i-- > 0) {
            if (this.charAt(i) == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int indexOf(String s, int index) {
        int sMax = s.length();
        if (sMax == 0) {
            return index;
        }
        int iMax = this.length();
        char firstChar = s.charAt(0);
        int pos = index;
        while ((pos = this.indexOf(firstChar, pos)) >= 0 && pos + sMax <= iMax) {
            if (this.matchChars(s, pos)) {
                return pos;
            }
            if (++pos + sMax < iMax) continue;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(String s, int index) {
        int sMax = s.length();
        if (sMax == 0) {
            return index;
        }
        int pos = index;
        char lastChar = s.charAt(s.length() - 1);
        while ((pos = this.lastIndexOf(lastChar, pos)) >= sMax) {
            if (this.matchCharsReversed(s, pos + 1)) {
                return pos - sMax;
            }
            if (--pos >= sMax) continue;
        }
        return -1;
    }

    @Override
    public String toVisibleWhitespaceString() {
        StringBuilder sb = new StringBuilder();
        int iMax = this.length();
        for (int i = 0; i < iMax; ++i) {
            char c = this.charAt(i);
            String s = visibleSpacesMap.get(Character.valueOf(c));
            if (s != null) {
                sb.append(s);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public boolean isContinuedBy(BasedSequence other) {
        return other.length() > 0 && this.length() > 0 && other.getBase() == this.getBase() && other.getStartOffset() == this.getEndOffset();
    }

    @Override
    public boolean isContinuationOf(BasedSequence other) {
        return other.length() > 0 && this.length() > 0 && other.getBase() == this.getBase() && other.getEndOffset() == this.getStartOffset();
    }

    @Override
    public BasedSequence spliceAtEnd(BasedSequence other) {
        assert (this.isContinuedBy(other)) : "sequence[" + this.getStartOffset() + ", " + this.getEndOffset() + "] is not continued by other[" + other.getStartOffset() + ", " + other.getEndOffset() + "]";
        return this.baseSubSequence(this.getStartOffset(), other.getEndOffset());
    }

    @Override
    public boolean contains(BasedSequence other) {
        return this.getBase() == other.getBase() && this.getStartOffset() < other.getEndOffset() && this.getEndOffset() > other.getStartOffset();
    }

    @Override
    public List<BasedSequence> split(char delimiter) {
        return this.split(delimiter, 0);
    }

    @Override
    public List<BasedSequence> split(char delimiter, int limit) {
        return this.split(delimiter, limit, 0);
    }

    @Override
    public List<BasedSequence> split(char delimiter, int limit, int flags) {
        return this.split(delimiter, limit, flags, WHITESPACE_CHARS);
    }

    @Override
    public List<BasedSequence> split(String delimiter) {
        return this.split(delimiter, 0);
    }

    @Override
    public List<BasedSequence> split(String delimiter, int limit) {
        return this.split(delimiter, limit, 0);
    }

    @Override
    public List<BasedSequence> split(String delimiter, int limit, int flags) {
        return this.split(delimiter, limit, flags, WHITESPACE_CHARS);
    }

    @Override
    public List<BasedSequence> split(char delimiter, int limit, int flags, String trimChars) {
        if (trimChars == null) {
            trimChars = WHITESPACE_CHARS;
        }
        if (limit < 1) {
            limit = Integer.MAX_VALUE;
        }
        boolean includeDelimParts = (flags & 8) != 0;
        int includeDelims = !includeDelimParts && (flags & 1) != 0 ? 1 : 0;
        boolean trimParts = (flags & 2) != 0;
        boolean skipEmpty = (flags & 4) != 0;
        ArrayList<BasedSequence> items = new ArrayList<BasedSequence>();
        int lastPos = 0;
        int length = this.length();
        if (limit > 1) {
            int pos;
            while (lastPos < length && (pos = this.indexOf(delimiter, lastPos)) >= 0) {
                if (lastPos < pos || !skipEmpty) {
                    BasedSequence item = this.subSequence(lastPos, pos + includeDelims);
                    if (trimParts) {
                        item = item.trim(trimChars);
                    }
                    if (!item.isEmpty() || !skipEmpty) {
                        items.add(item);
                        if (includeDelimParts) {
                            items.add(this.subSequence(pos, pos + 1));
                        }
                        if (items.size() >= limit - 1) {
                            lastPos = pos + 1;
                            break;
                        }
                    }
                }
                lastPos = pos + 1;
            }
        }
        if (lastPos < length) {
            BasedSequence item = this.subSequence(lastPos, length);
            if (trimParts) {
                item = item.trim(trimChars);
            }
            if (!item.isEmpty() || !skipEmpty) {
                items.add(item);
            }
        }
        return items;
    }

    @Override
    public List<BasedSequence> split(String delimiter, int limit, int flags, String trimChars) {
        if (trimChars == null) {
            trimChars = WHITESPACE_CHARS;
        }
        if (limit < 1) {
            limit = Integer.MAX_VALUE;
        }
        boolean includeDelimParts = (flags & 8) != 0;
        boolean includeDelims = !includeDelimParts && (flags & 1) != 0;
        boolean trimParts = (flags & 2) != 0;
        boolean skipEmpty = (flags & 4) != 0;
        ArrayList<BasedSequence> items = new ArrayList<BasedSequence>();
        int lastPos = 0;
        int length = this.length();
        if (limit > 1) {
            int pos;
            while (lastPos < length && (pos = this.indexOf(delimiter, lastPos)) >= 0) {
                if (lastPos < pos || !skipEmpty) {
                    BasedSequence item = this.subSequence(lastPos, pos + delimiter.length());
                    if (trimParts) {
                        item = item.trim(trimChars);
                    }
                    if (!item.isEmpty() || !skipEmpty) {
                        items.add(item);
                        if (includeDelimParts) {
                            items.add(this.subSequence(pos, pos + 1));
                        }
                        if (items.size() >= limit - 1) {
                            lastPos = pos + 1;
                            break;
                        }
                    }
                }
                lastPos = pos + 1;
            }
        }
        if (lastPos < length) {
            BasedSequence item = this.subSequence(lastPos, length);
            if (trimParts) {
                item = item.trim(trimChars);
            }
            if (!item.isEmpty() || !skipEmpty) {
                items.add(item);
            }
        }
        return items;
    }

    static {
        HashMap<Character, String> charMap = new HashMap<Character, String>();
        visibleSpacesMap = charMap;
        charMap.put(Character.valueOf('\n'), "\\n");
        charMap.put(Character.valueOf('\r'), "\\r");
        charMap.put(Character.valueOf('\f'), "\\f");
        charMap.put(Character.valueOf('\t'), "\\u2192");
    }
}

