/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.ReplacedTextRegion;
import com.vladsch.flexmark.util.sequence.SegmentedSequence;
import java.util.ArrayList;

public class ReplacedTextMapper {
    private ReplacedTextMapper parent;
    private BasedSequence original;
    private ArrayList<ReplacedTextRegion> regions = new ArrayList();
    private ArrayList<BasedSequence> replacedSegments = new ArrayList();
    private int replacedLength = 0;
    private BasedSequence replacedSequence = null;

    public ReplacedTextMapper(BasedSequence original) {
        this.original = original;
        this.parent = null;
    }

    private ReplacedTextMapper(ReplacedTextMapper other) {
        this.parent = other.parent;
        this.original = other.original;
        this.regions = other.regions;
        this.replacedSegments = other.replacedSegments;
        this.replacedLength = other.replacedLength;
        this.replacedSequence = other.getReplacedSequence();
    }

    public void startNestedReplacement(BasedSequence sequence) {
        assert (sequence.equals(this.getReplacedSequence()));
        this.parent = new ReplacedTextMapper(this);
        this.original = sequence;
        this.regions = new ArrayList();
        this.replacedSegments = new ArrayList();
        this.replacedLength = 0;
        this.replacedSequence = null;
    }

    public boolean isModified() {
        return this.replacedLength > 0;
    }

    public boolean isFinalized() {
        return this.replacedSequence != null;
    }

    private void finalizeMods() {
        if (this.replacedSequence == null) {
            this.replacedSequence = SegmentedSequence.of(this.replacedSegments);
        }
    }

    public ReplacedTextMapper getParent() {
        return this.parent;
    }

    public void addReplacedText(int startIndex, int endIndex, BasedSequence replacedSequence) {
        if (this.isFinalized()) {
            throw new IllegalStateException("Cannot modify finalized ReplacedTextMapper");
        }
        this.regions.add(new ReplacedTextRegion(((BasedSequence)this.original.subSequence(startIndex, endIndex)).getSourceRange(), new Range(startIndex, endIndex), new Range(this.replacedLength, this.replacedLength + replacedSequence.length())));
        this.replacedLength += replacedSequence.length();
        this.replacedSegments.add(replacedSequence);
    }

    public void addOriginalText(int startIndex, int endIndex) {
        if (this.isFinalized()) {
            throw new IllegalStateException("Cannot modify finalized ReplacedTextMapper");
        }
        if (startIndex < endIndex) {
            BasedSequence originalSegment = (BasedSequence)this.original.subSequence(startIndex, endIndex);
            this.regions.add(new ReplacedTextRegion(originalSegment.getSourceRange(), new Range(startIndex, endIndex), new Range(this.replacedLength, this.replacedLength + originalSegment.length())));
            this.replacedLength += originalSegment.length();
            this.replacedSegments.add(originalSegment);
        }
    }

    public ArrayList<ReplacedTextRegion> getRegions() {
        this.finalizeMods();
        return this.regions;
    }

    public ArrayList<BasedSequence> getReplacedSegments() {
        this.finalizeMods();
        return this.replacedSegments;
    }

    public BasedSequence getReplacedSequence() {
        this.finalizeMods();
        return this.replacedSequence;
    }

    public int getReplacedLength() {
        this.finalizeMods();
        return this.replacedLength;
    }

    private int parentOriginalOffset(int originalIndex) {
        return this.parent != null ? this.parent.originalOffset(originalIndex) : originalIndex;
    }

    public int originalOffset(int replacedIndex) {
        this.finalizeMods();
        if (this.regions.isEmpty()) {
            return this.parentOriginalOffset(replacedIndex);
        }
        if (replacedIndex == this.replacedLength) {
            return this.parentOriginalOffset(this.original.length());
        }
        int originalIndex = replacedIndex;
        for (ReplacedTextRegion region : this.regions) {
            if (!region.containsReplacedIndex(replacedIndex)) continue;
            originalIndex = region.getOriginalRange().getStart() + replacedIndex - region.getReplacedRange().getStart();
            if (originalIndex <= region.getOriginalRange().getEnd()) break;
            originalIndex = region.getOriginalRange().getEnd();
            break;
        }
        return this.parentOriginalOffset(originalIndex);
    }
}

