/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.format;

import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.format.MarkdownTable;
import com.vladsch.flexmark.util.format.TableCell;
import com.vladsch.flexmark.util.format.TableCellConsumer;
import com.vladsch.flexmark.util.format.TableCellManipulator;
import com.vladsch.flexmark.util.sequence.PrefixedSubSequence;
import java.util.ArrayList;
import java.util.List;

public class TableRow {
    protected final List<TableCell> cells;
    protected int beforeOffset = Integer.MAX_VALUE;
    protected int afterOffset = Integer.MAX_VALUE;
    private boolean normalized = true;

    public TableRow() {
        this.cells = new ArrayList<TableCell>();
    }

    public List<TableCell> getCells() {
        return this.cells;
    }

    public void forAllCells(TableCellConsumer consumer) {
        this.forAllCells(0, Integer.MAX_VALUE, consumer);
    }

    public void forAllCells(int startIndex, TableCellConsumer consumer) {
        this.forAllCells(startIndex, Integer.MAX_VALUE, consumer);
    }

    public void forAllCells(int startIndex, int count, TableCellConsumer consumer) {
        this.forAllCells(startIndex, count, (TableCell cell, int cellIndex, int cellColumn, int allCellIndex) -> {
            consumer.accept(cell, cellIndex, cellColumn);
            return 0;
        });
    }

    public void forAllCells(TableCellManipulator manipulator) {
        this.forAllCells(0, Integer.MAX_VALUE, manipulator);
    }

    public void forAllCells(int startIndex, TableCellManipulator manipulator) {
        this.forAllCells(startIndex, Integer.MAX_VALUE, manipulator);
    }

    public void forAllCells(int startIndex, int count, TableCellManipulator manipulator) {
        int iMax = this.cells.size();
        if (startIndex < iMax && count > 0) {
            int column = 0;
            int remaining = count;
            int allCellsIndex = 0;
            int i = 0;
            while (i < iMax) {
                TableCell cell = this.cells.get(i);
                if (i >= startIndex) {
                    int result = manipulator.apply(cell, i, column, allCellsIndex);
                    if (result == Integer.MIN_VALUE) {
                        return;
                    }
                    if (result < 0) {
                        allCellsIndex -= result;
                        remaining += result;
                        iMax += result;
                    } else {
                        i += result + 1;
                        column += cell.columnSpan;
                        --remaining;
                        iMax += result;
                    }
                    ++allCellsIndex;
                    if (remaining > 0) continue;
                    break;
                }
                ++i;
                ++allCellsIndex;
                column += cell.columnSpan;
            }
        }
    }

    public int getColumns() {
        return this.cells.size();
    }

    public int getTotalColumns() {
        return this.getSpannedColumns();
    }

    public int getSpannedColumns() {
        int columns = 0;
        for (TableCell cell : this.cells) {
            if (cell == null) continue;
            columns += cell.columnSpan;
        }
        return columns;
    }

    public int getBeforeOffset() {
        return this.beforeOffset;
    }

    public void setBeforeOffset(int beforeOffset) {
        this.beforeOffset = beforeOffset;
    }

    public int getAfterOffset() {
        return this.afterOffset;
    }

    public void setAfterOffset(int afterOffset) {
        this.afterOffset = afterOffset;
    }

    public int columnOf(int index) {
        return this.columnOfOrNull(index);
    }

    public Integer columnOfOrNull(Integer index) {
        if (index == null) {
            return null;
        }
        int columns = 0;
        int iMax = Utils.maxLimit(index, this.cells.size());
        for (int i = 0; i < iMax; ++i) {
            TableCell cell = this.cells.get(i);
            columns += cell.columnSpan;
        }
        return columns;
    }

    public void appendColumns(int count) {
        this.appendColumns(count, null);
    }

    public void appendColumns(int count, TableCell tableCell) {
        if (tableCell == null || tableCell.columnSpan == 0) {
            tableCell = this.defaultCell();
        }
        for (int i = 0; i < count; ++i) {
            this.cells.add(this.cells.size(), tableCell);
        }
    }

    public TableCell defaultCell() {
        return new TableCell(" ", 1, 1);
    }

    public void addColumn(int index) {
        this.cells.add(index, this.defaultCell());
    }

    public void insertColumns(int column, int count) {
        this.insertColumns(column, count, null);
    }

    public void insertColumns(int column, int count, TableCell tableCell) {
        int totalColumns;
        if (count <= 0 || column < 0) {
            return;
        }
        this.normalizeIfNeeded();
        if (tableCell == null || tableCell.columnSpan == 0) {
            tableCell = this.defaultCell();
        }
        if (column >= (totalColumns = this.getTotalColumns())) {
            this.appendColumns(count, tableCell);
        } else {
            MarkdownTable.IndexSpanOffset indexSpan = this.indexOf(column);
            int index = indexSpan.index;
            int spanOffset = indexSpan.spanOffset;
            if (spanOffset > 0 && index < this.cells.size()) {
                TableCell cell = this.cells.get(index);
                if (tableCell.text.isBlank() || count > 1) {
                    this.cells.remove(index);
                    this.cells.add(index, cell.withColumnSpan(cell.columnSpan + count));
                } else {
                    this.cells.remove(index);
                    this.cells.add(index, cell.withColumnSpan(spanOffset));
                    this.cells.add(index + 1, tableCell.withColumnSpan(Utils.minLimit(1, cell.columnSpan - spanOffset + 1)));
                }
            } else {
                TableCell cell = this.cells.get(index);
                for (int i = 0; i < count; ++i) {
                    this.cells.add(index, tableCell);
                }
            }
        }
    }

    public void deleteColumns(int column, int count) {
        TableCell cell;
        if (count <= 0 || column < 0) {
            return;
        }
        this.normalizeIfNeeded();
        MarkdownTable.IndexSpanOffset indexSpan = this.indexOf(column);
        int index = indexSpan.index;
        int spanOffset = indexSpan.spanOffset;
        for (int remaining = count; index < this.cells.size() && remaining > 0; remaining -= cell.columnSpan - spanOffset) {
            cell = this.cells.get(index);
            this.cells.remove(index);
            if (spanOffset > 0) {
                if (cell.columnSpan - spanOffset > remaining) {
                    this.cells.add(index, cell.withColumnSpan(cell.columnSpan - remaining));
                    break;
                }
                this.cells.add(index, cell.withColumnSpan(spanOffset));
                ++index;
            } else if (cell.columnSpan - spanOffset > remaining) {
                this.cells.add(index, this.defaultCell().withColumnSpan(cell.columnSpan - remaining));
                break;
            }
            spanOffset = 0;
        }
    }

    public void moveColumn(int fromColumn, int toColumn) {
        if (fromColumn < 0 || toColumn < 0) {
            return;
        }
        this.normalizeIfNeeded();
        int maxColumn = this.getTotalColumns();
        if (fromColumn >= maxColumn) {
            return;
        }
        if (toColumn >= maxColumn) {
            toColumn = maxColumn - 1;
        }
        if (fromColumn != toColumn && fromColumn < maxColumn && toColumn < maxColumn) {
            MarkdownTable.IndexSpanOffset fromIndexSpan = this.indexOf(fromColumn);
            int fromIndex = fromIndexSpan.index;
            int fromSpanOffset = fromIndexSpan.spanOffset;
            TableCell cell = this.cells.get(fromIndex).withColumnSpan(1);
            MarkdownTable.IndexSpanOffset toIndexSpan = this.indexOf(toColumn);
            int toIndex = toIndexSpan.index;
            int toSpanOffset = toIndexSpan.spanOffset;
            if (toIndex == fromIndex) {
                boolean bl = false;
            } else if (fromSpanOffset > 0) {
                this.insertColumns(toColumn + (fromColumn <= toColumn ? 1 : 0), 1, this.defaultCell());
                this.deleteColumns(fromColumn + (toColumn <= fromColumn ? 1 : 0), 1);
            } else {
                this.insertColumns(toColumn + (fromColumn <= toColumn ? 1 : 0), 1, cell.withColumnSpan(1));
                this.deleteColumns(fromColumn + (toColumn <= fromColumn ? 1 : 0), 1);
            }
        }
    }

    public TableRow expandTo(int column) {
        return this.expandTo(column, TableCell.NULL);
    }

    public TableRow expandTo(int column, TableCell cell) {
        if (cell == null || cell.columnSpan == 0) {
            this.normalized = false;
        }
        while (column >= this.cells.size()) {
            this.cells.add(cell);
        }
        return this;
    }

    void fillMissingColumns(Integer minColumn, int maxColumns) {
        int columns = this.getSpannedColumns();
        if (columns < maxColumns) {
            TableCell prevCell;
            int columnIndex = minColumn == null ? this.cells.size() : minColumn.intValue();
            int count = maxColumns - columns;
            if (minColumn == null || minColumn >= columns) {
                columnIndex = this.cells.size();
            }
            TableCell empty = this.defaultCell();
            TableCell tableCell = prevCell = columnIndex > 0 ? this.cells.get(columnIndex - 1) : empty;
            while (count-- > 0) {
                int endOffset = prevCell.getEndOffset();
                empty = empty.withText(PrefixedSubSequence.of(" ", prevCell.getLastSegment().getBaseSequence(), endOffset, endOffset));
                this.cells.add(columnIndex <= this.cells.size() ? columnIndex : this.cells.size(), empty);
                prevCell = empty;
                ++columnIndex;
            }
        }
    }

    public void set(int column, TableCell cell) {
        this.expandTo(column, null);
        this.cells.set(column, cell);
    }

    public boolean isEmptyColumn(int column) {
        int index = this.indexOf((int)column).index;
        return index >= this.cells.size() || this.cells.get((int)index).text.isBlank();
    }

    public boolean isEmpty() {
        for (TableCell cell : this.cells) {
            if (cell == null || cell.text.isBlank()) continue;
            return false;
        }
        return true;
    }

    public MarkdownTable.IndexSpanOffset indexOf(int column) {
        return this.indexOfOrNull(column);
    }

    public MarkdownTable.IndexSpanOffset indexOfOrNull(Integer column) {
        if (column == null) {
            return null;
        }
        int remainingColumns = column;
        int index = 0;
        for (TableCell cell : this.cells) {
            if (cell.columnSpan > remainingColumns) {
                int spanOffset = remainingColumns;
                return new MarkdownTable.IndexSpanOffset(index, spanOffset);
            }
            remainingColumns -= cell.columnSpan;
            if (cell.columnSpan <= 0) continue;
            ++index;
        }
        return new MarkdownTable.IndexSpanOffset(index, 0);
    }

    public void normalizeIfNeeded() {
        if (!this.normalized) {
            this.normalize();
        }
    }

    public void normalize() {
        int column = 0;
        while (column < this.cells.size()) {
            TableCell cell = this.cells.get(column);
            if (cell == null || cell == TableCell.NULL) {
                this.cells.remove(column);
                continue;
            }
            ++column;
        }
        this.normalized = true;
    }

    private CharSequence dumpCells() {
        StringBuilder sb = new StringBuilder();
        for (TableCell cell : this.cells) {
            sb.append("    ").append(cell.toString()).append("\n");
        }
        return sb;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ beforeOffset=" + this.beforeOffset + ", afterOffset=" + this.afterOffset + ", normalized=" + this.normalized + ", cells=[\n" + this.dumpCells() + "    ]\n  }";
    }
}

