/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html;

import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.html.Attribute;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.html.HtmlFormattingAppendable;
import com.vladsch.flexmark.util.html.LineFormattingAppendable;
import com.vladsch.flexmark.util.html.LineFormattingAppendableImpl;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.RepeatedCharSequence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class HtmlFormattingAppendableBase<T extends HtmlFormattingAppendableBase>
implements HtmlFormattingAppendable {
    private LineFormattingAppendable out;
    private Attributes currentAttributes;
    private boolean indentOnFirstEol = false;
    private boolean lineOnChildText = false;
    private boolean withAttributes = false;
    private boolean suppressOpenTagLine = false;
    private boolean suppressCloseTagLine = false;
    private final Stack<String> myOpenTags = new Stack();

    public HtmlFormattingAppendableBase(LineFormattingAppendable other, boolean inheritIndent) {
        this.out = new LineFormattingAppendableImpl(other.getOptions());
        this.out.setIndentPrefix(other.getIndentPrefix());
    }

    public HtmlFormattingAppendableBase(int indentSize, int formatOptions) {
        this.out = new LineFormattingAppendableImpl(formatOptions);
        this.out.setIndentPrefix(RepeatedCharSequence.of(" ", indentSize).toString());
    }

    public boolean isSuppressOpenTagLine() {
        return this.suppressOpenTagLine;
    }

    public void setSuppressOpenTagLine(boolean suppressOpenTagLine) {
        this.suppressOpenTagLine = suppressOpenTagLine;
    }

    public boolean isSuppressCloseTagLine() {
        return this.suppressCloseTagLine;
    }

    public T setSuppressCloseTagLine(boolean suppressCloseTagLine) {
        this.suppressCloseTagLine = suppressCloseTagLine;
        return (T)this;
    }

    public String toString() {
        return this.out.toString();
    }

    public T openPre() {
        this.out.openPreFormatted(true);
        return (T)this;
    }

    public T closePre() {
        this.out.closePreFormatted();
        return (T)this;
    }

    @Override
    public boolean inPre() {
        return this.out.isPreFormatted();
    }

    private boolean haveOptions(int options) {
        return (this.out.getOptions() & options) != 0;
    }

    public T raw(CharSequence s) {
        this.out.append(s);
        return (T)this;
    }

    public T raw(CharSequence s, int count) {
        int i = count;
        while (i-- > 0) {
            this.out.append(s);
        }
        return (T)this;
    }

    public T rawPre(CharSequence s) {
        if (this.out.getPendingEOL() == 0 && s.length() > 0 && s.charAt(0) == '\n') {
            this.out.line();
            s = s.subSequence(1, s.length());
        }
        this.out.openPreFormatted(true).append(s).closePreFormatted();
        return (T)this;
    }

    public T rawIndentedPre(CharSequence s) {
        this.out.openPreFormatted(true).append(s).closePreFormatted();
        return (T)this;
    }

    public T text(CharSequence s) {
        this.out.append(Escaping.escapeHtml(s, false));
        return (T)this;
    }

    public T attr(CharSequence attrName, CharSequence value) {
        if (this.currentAttributes == null) {
            this.currentAttributes = new Attributes();
        }
        this.currentAttributes.addValue(attrName, value);
        return (T)this;
    }

    public T attr(Attribute ... attribute) {
        if (this.currentAttributes == null) {
            this.currentAttributes = new Attributes();
        }
        for (Attribute attr : attribute) {
            this.currentAttributes.addValue(attr.getName(), attr.getValue());
        }
        return (T)this;
    }

    public T attr(Attributes attributes) {
        if (attributes != null && !attributes.isEmpty()) {
            if (this.currentAttributes == null) {
                this.currentAttributes = new Attributes(attributes);
            } else {
                this.currentAttributes.addValues(attributes);
            }
        }
        return (T)this;
    }

    public T withAttr() {
        this.withAttributes = true;
        return (T)this;
    }

    @Override
    public Attributes getAttributes() {
        return this.currentAttributes;
    }

    public T setAttributes(Attributes attributes) {
        this.currentAttributes = attributes;
        return (T)this;
    }

    public T withCondLineOnChildText() {
        this.lineOnChildText = true;
        return (T)this;
    }

    public T withCondIndent() {
        this.indentOnFirstEol = true;
        return (T)this;
    }

    public T tag(CharSequence tagName) {
        return (T)this.tag(tagName, false);
    }

    public T tag(CharSequence tagName, Runnable runnable) {
        return (T)this.tag(tagName, false, false, runnable);
    }

    public T tagVoid(CharSequence tagName) {
        return (T)this.tag(tagName, true);
    }

    protected String getOpenTagText() {
        return Utils.splice(this.myOpenTags, ", ", true);
    }

    protected void pushTag(CharSequence tagName) {
        this.myOpenTags.push(String.valueOf(tagName));
    }

    protected void popTag(CharSequence tagName) {
        if (this.myOpenTags.isEmpty()) {
            throw new IllegalStateException("Close tag '" + tagName + "' with no tags open");
        }
        String openTag = this.myOpenTags.peek();
        if (!openTag.equals(String.valueOf(tagName))) {
            throw new IllegalStateException("Close tag '" + tagName + "' does not match '" + openTag + "' in " + this.getOpenTagText());
        }
        this.myOpenTags.pop();
    }

    protected void tagOpened(CharSequence tagName) {
        this.pushTag(tagName);
    }

    protected void tagClosed(CharSequence tagName) {
        this.popTag(tagName);
    }

    @Override
    public Stack<String> getOpenTags() {
        return this.myOpenTags;
    }

    @Override
    public List<String> getOpenTagsAfterLast(CharSequence latestTag) {
        int iMax;
        if (this.myOpenTags.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> tagList = new ArrayList<String>(this.myOpenTags);
        int lastPos = iMax = tagList.size();
        String lastTag = String.valueOf(latestTag);
        int i = iMax;
        while (i-- > 0) {
            if (!((String)tagList.get(i)).equals(lastTag)) continue;
            lastPos = i + 1;
            break;
        }
        return tagList.subList(lastPos, iMax);
    }

    public T tag(CharSequence tagName, boolean voidElement) {
        if (tagName.length() == 0 || tagName.charAt(0) == '/') {
            return (T)this.closeTag(tagName);
        }
        Attributes attributes = null;
        if (this.withAttributes) {
            attributes = this.currentAttributes;
            this.currentAttributes = null;
            this.withAttributes = false;
        }
        this.out.append("<");
        this.out.append(tagName);
        if (attributes != null && !attributes.isEmpty()) {
            for (Attribute attribute : attributes.values()) {
                String attributeValue = attribute.getValue();
                if (attribute.isNonRendering()) continue;
                this.out.append(" ");
                this.out.append(Escaping.escapeHtml(attribute.getName(), true));
                this.out.append("=\"");
                this.out.append(Escaping.escapeHtml(attributeValue, true));
                this.out.append("\"");
            }
        }
        if (voidElement) {
            this.out.append(" />");
        } else {
            this.out.append(">");
            this.tagOpened(tagName);
        }
        return (T)this;
    }

    public T closeTag(CharSequence tagName) {
        if (tagName.length() == 0) {
            throw new IllegalStateException("closeTag called with tag:'" + tagName + "'");
        }
        if (tagName.charAt(0) == '/') {
            this.out.append("<").append(tagName).append(">");
            this.tagClosed(tagName.subSequence(1, tagName.length()));
        } else {
            this.out.append("</").append(tagName).append(">");
            this.tagClosed(tagName);
        }
        return (T)this;
    }

    public T tag(CharSequence tagName, boolean withIndent, boolean withLine, Runnable runnable) {
        boolean isLineOnChildText = this.lineOnChildText;
        boolean isIndentOnFirstEol = this.indentOnFirstEol;
        this.lineOnChildText = false;
        this.indentOnFirstEol = false;
        if (withIndent && !this.suppressOpenTagLine) {
            this.out.line();
        }
        this.tag(tagName, false);
        if (withIndent && !isIndentOnFirstEol) {
            this.out.indent();
        }
        if ((this.out.getOptions() & 0x10) != 0) {
            runnable.run();
        } else {
            final boolean[] hadConditionalIndent = new boolean[]{false};
            Runnable indentOnFirstEol = new Runnable(){

                @Override
                public void run() {
                    hadConditionalIndent[0] = true;
                }
            };
            if (isLineOnChildText) {
                this.out.setLineOnFirstText();
            }
            if (isIndentOnFirstEol) {
                this.out.addIndentOnFirstEOL(indentOnFirstEol);
            }
            runnable.run();
            if (isLineOnChildText) {
                this.out.clearLineOnFirstText();
            }
            if (hadConditionalIndent[0]) {
                this.out.unIndentNoEol();
            } else {
                this.out.removeIndentOnFirstEOL(indentOnFirstEol);
            }
        }
        if (withIndent && !isIndentOnFirstEol) {
            this.out.unIndent();
        }
        if (withLine && !this.suppressCloseTagLine) {
            this.out.line();
        }
        this.closeTag(tagName);
        if (withIndent && !this.suppressCloseTagLine) {
            this.out.line();
        }
        return (T)this;
    }

    public T tagVoidLine(CharSequence tagName) {
        ((HtmlFormattingAppendableBase)((HtmlFormattingAppendableBase)this.lineIf(!this.suppressOpenTagLine)).tagVoid(tagName)).lineIf(!this.suppressCloseTagLine);
        return (T)this;
    }

    public T tagLine(CharSequence tagName) {
        ((HtmlFormattingAppendableBase)((HtmlFormattingAppendableBase)this.lineIf(!this.suppressOpenTagLine)).tag(tagName)).lineIf(!this.suppressCloseTagLine);
        return (T)this;
    }

    public T tagLine(CharSequence tagName, boolean voidElement) {
        ((HtmlFormattingAppendableBase)((HtmlFormattingAppendableBase)this.lineIf(!this.suppressOpenTagLine)).tag(tagName, voidElement)).lineIf(!this.suppressCloseTagLine);
        return (T)this;
    }

    public T tagLine(CharSequence tagName, Runnable runnable) {
        ((HtmlFormattingAppendableBase)((HtmlFormattingAppendableBase)this.lineIf(!this.suppressOpenTagLine)).tag(tagName, false, false, runnable)).lineIf(!this.suppressCloseTagLine);
        return (T)this;
    }

    public T tagIndent(CharSequence tagName, Runnable runnable) {
        this.tag(tagName, true, false, runnable);
        return (T)this;
    }

    public T tagLineIndent(CharSequence tagName, Runnable runnable) {
        this.tag(tagName, true, true, runnable);
        return (T)this;
    }

    @Override
    public boolean isPendingSpace() {
        return this.out.isPendingSpace();
    }

    @Override
    public boolean isPreFormatted() {
        return this.out.isPreFormatted();
    }

    @Override
    public boolean isPreFormattedLine(int line) {
        return this.out.isPreFormattedLine(line);
    }

    @Override
    public CharSequence getIndentPrefix() {
        return this.out.getIndentPrefix();
    }

    @Override
    public CharSequence getPrefix() {
        return this.out.getPrefix();
    }

    @Override
    public int column() {
        return this.out.column();
    }

    @Override
    public int getLineCount() {
        return this.out.getLineCount();
    }

    @Override
    public int getOptions() {
        return this.out.getOptions();
    }

    @Override
    public int getPendingEOL() {
        return this.out.getPendingEOL();
    }

    @Override
    public int getPendingSpace() {
        return this.out.getPendingSpace();
    }

    @Override
    public int offset() {
        return this.out.offset();
    }

    @Override
    public int offsetWithPending() {
        return this.out.offsetWithPending();
    }

    @Override
    public int textOnlyOffset() {
        return this.out.textOnlyOffset();
    }

    @Override
    public int textOnlyOffsetWithPending() {
        return this.out.textOnlyOffsetWithPending();
    }

    @Override
    public List<BasedSequence> getLinePrefixes(int startLine, int endLine) {
        return this.out.getLinePrefixes(startLine, endLine);
    }

    @Override
    public List<CharSequence> getLineContents(int startLine, int endLine) {
        return this.out.getLineContents(startLine, endLine);
    }

    @Override
    public List<CharSequence> getLines(int startLine, int endLine) {
        return this.out.getLines(startLine, endLine);
    }

    @Override
    public String toString(int maxBlankLines) {
        return this.out.toString(maxBlankLines);
    }

    public T addIndentOnFirstEOL(Runnable runnable) {
        this.out.addIndentOnFirstEOL(runnable);
        return (T)this;
    }

    public T addLine() {
        this.out.addLine();
        return (T)this;
    }

    public T addPrefix(CharSequence prefix) {
        this.out.addPrefix(prefix);
        return (T)this;
    }

    public T addPrefix(CharSequence prefix, boolean afterEol) {
        this.out.addPrefix(prefix, afterEol);
        return (T)this;
    }

    public T append(char c) {
        this.out.append(c);
        return (T)this;
    }

    public T append(CharSequence csq) {
        this.out.append(csq);
        return (T)this;
    }

    public T append(CharSequence csq, int start, int end) {
        this.out.append(csq, start, end);
        return (T)this;
    }

    public T append(LineFormattingAppendable lines, int startLine, int endLine) {
        this.out.append(lines, startLine, endLine);
        return (T)this;
    }

    public T appendTo(Appendable out, int maxBlankLines, CharSequence prefix, int startLine, int endLine) throws IOException {
        this.out.appendTo(out, maxBlankLines, prefix, startLine, endLine);
        return (T)this;
    }

    public T blankLine() {
        this.out.blankLine();
        return (T)this;
    }

    public T blankLine(int count) {
        this.out.blankLine(count);
        return (T)this;
    }

    public T blankLineIf(boolean predicate) {
        this.out.blankLineIf(predicate);
        return (T)this;
    }

    public T closePreFormatted() {
        this.out.closePreFormatted();
        return (T)this;
    }

    public T indent() {
        this.out.indent();
        return (T)this;
    }

    public T line() {
        this.out.line();
        return (T)this;
    }

    public T lineIf(boolean predicate) {
        this.out.lineIf(predicate);
        return (T)this;
    }

    public T lineOnFirstText(boolean value) {
        this.out.lineOnFirstText(value);
        return (T)this;
    }

    public T lineWithTrailingSpaces(int count) {
        this.out.lineWithTrailingSpaces(count);
        return (T)this;
    }

    public T openPreFormatted() {
        this.out.openPreFormatted();
        return (T)this;
    }

    public T openPreFormatted(boolean keepIndent) {
        this.out.openPreFormatted(true);
        return (T)this;
    }

    public T popPrefix() {
        this.out.popPrefix();
        return (T)this;
    }

    public T popPrefix(boolean afterEol) {
        this.out.popPrefix(afterEol);
        return (T)this;
    }

    public T prefixLines(CharSequence prefix, boolean addAfterLinePrefix, int startLine, int endLine) {
        this.out.prefixLines(prefix, addAfterLinePrefix, startLine, endLine);
        return (T)this;
    }

    public T prefixLines(CharSequence prefix, int startLine, int endLine) {
        this.out.prefixLines(prefix, startLine, endLine);
        return (T)this;
    }

    public T pushPrefix() {
        this.out.pushPrefix();
        return (T)this;
    }

    public T removeIndentOnFirstEOL(Runnable runnable) {
        this.out.removeIndentOnFirstEOL(runnable);
        return (T)this;
    }

    public T removeLines(int startLine, int endLine) {
        this.out.removeLines(startLine, endLine);
        return (T)this;
    }

    public T repeat(char c, int count) {
        this.out.repeat(c, count);
        return (T)this;
    }

    public T repeat(CharSequence csq, int count) {
        this.out.repeat(csq, count);
        return (T)this;
    }

    public T repeat(CharSequence csq, int start, int end, int count) {
        this.out.repeat(csq, start, end, count);
        return (T)this;
    }

    public T setIndentPrefix(CharSequence prefix) {
        this.out.setIndentPrefix(prefix);
        return (T)this;
    }

    public T setOptions(int options) {
        this.out.setOptions(options);
        return (T)this;
    }

    public T setPrefix(CharSequence prefix) {
        this.out.setPrefix(prefix);
        return (T)this;
    }

    public T setPrefix(CharSequence prefix, boolean afterEol) {
        this.out.setPrefix(prefix, afterEol);
        return (T)this;
    }

    public T unIndent() {
        this.out.unIndent();
        return (T)this;
    }

    public T unIndentNoEol() {
        this.out.unIndentNoEol();
        return (T)this;
    }
}

