/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection.iteration;

import com.vladsch.flexmark.util.collection.iteration.BitSetIterator;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterator;
import java.util.BitSet;

public class BitSetIterable
implements ReversibleIterable<Integer> {
    private final BitSet myBitSet;
    private final boolean myIsReversed;

    public BitSetIterable(BitSet bitSet) {
        this(bitSet, false);
    }

    public BitSetIterable(BitSet bitSet, boolean reversed) {
        this.myBitSet = bitSet;
        this.myIsReversed = reversed;
    }

    @Override
    public boolean isReversed() {
        return this.myIsReversed;
    }

    @Override
    public ReversibleIterator<Integer> iterator() {
        return new BitSetIterator(this.myBitSet, this.myIsReversed);
    }

    @Override
    public ReversibleIterable<Integer> reversed() {
        return new BitSetIterable(this.myBitSet, !this.myIsReversed);
    }

    @Override
    public ReversibleIterator<Integer> reversedIterator() {
        return new BitSetIterator(this.myBitSet, !this.myIsReversed);
    }
}

