/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.util.KeepType;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class NodeRepository<T>
implements Map<String, T> {
    protected final ArrayList<T> nodeList = new ArrayList();
    protected final Map<String, T> nodeMap = new HashMap<String, T>();
    protected final KeepType keepType;

    public abstract DataKey<? extends NodeRepository<T>> getDataKey();

    public abstract DataKey<KeepType> getKeepDataKey();

    public NodeRepository(DataHolder options) {
        this.keepType = options == null ? KeepType.LOCKED : options.get(this.getKeepDataKey());
    }

    public String normalizeKey(CharSequence key) {
        return key.toString();
    }

    public T getFromRaw(CharSequence rawKey) {
        return this.nodeMap.get(this.normalizeKey(rawKey));
    }

    public T putRawKey(CharSequence key, T t) {
        return this.put(this.normalizeKey(key), t);
    }

    @Override
    public T put(String s, T t) {
        T another;
        this.nodeList.add(t);
        if (this.keepType == KeepType.LOCKED) {
            throw new IllegalStateException("Not allowed to modify LOCKED repository");
        }
        if (this.keepType != KeepType.LAST && (another = this.nodeMap.get(s)) != null) {
            if (this.keepType == KeepType.FAIL) {
                throw new IllegalStateException("Duplicate key " + s);
            }
            return another;
        }
        return this.nodeMap.put(s, t);
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> map) {
        if (this.keepType == KeepType.LOCKED) {
            throw new IllegalStateException("Not allowed to modify LOCKED repository");
        }
        if (this.keepType != KeepType.LAST) {
            for (String string : map.keySet()) {
                this.nodeMap.put(string, map.get(string));
            }
        } else {
            this.nodeMap.putAll(map);
        }
    }

    @Override
    public T remove(Object o) {
        if (this.keepType == KeepType.LOCKED) {
            throw new IllegalStateException("Not allowed to modify LOCKED repository");
        }
        return this.nodeMap.remove(o);
    }

    @Override
    public void clear() {
        if (this.keepType == KeepType.LOCKED) {
            throw new IllegalStateException("Not allowed to modify LOCKED repository");
        }
        this.nodeMap.clear();
    }

    @Override
    public int size() {
        return this.nodeMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.nodeMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.nodeMap.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.nodeMap.containsValue(o);
    }

    @Override
    public T get(Object o) {
        return this.nodeMap.get(o);
    }

    @Override
    public Set<String> keySet() {
        return this.nodeMap.keySet();
    }

    @Override
    public List<T> values() {
        return this.nodeList;
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.nodeMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.nodeMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.nodeMap.hashCode();
    }
}

