/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection.iteration;

import com.vladsch.flexmark.util.collection.Consumer;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterator;
import java.util.NoSuchElementException;

public class SparseIndexIterator
implements ReversibleIterator<Integer> {
    private final int[] myStarts;
    private final int[] myEnds;
    private final boolean myIsReversed;
    private int myIndex;
    private int myNext;
    private int myLast;

    public SparseIndexIterator(int[] starts, int[] ends, boolean reversed) {
        this.myStarts = starts;
        this.myEnds = ends;
        this.myIsReversed = reversed;
        int n = this.myIndex = reversed ? this.myEnds.length - 1 : 0;
        this.myNext = this.myIndex < 0 && this.myIndex >= this.myEnds.length ? -1 : (this.myIsReversed ? this.myEnds[this.myIndex] : this.myStarts[this.myIndex]);
        this.myLast = -1;
    }

    @Override
    public boolean isReversed() {
        return this.myIsReversed;
    }

    @Override
    public boolean hasNext() {
        return this.myNext != -1;
    }

    @Override
    public Integer next() {
        if (this.myNext == -1) {
            throw new NoSuchElementException();
        }
        this.myLast = this.myNext;
        if (this.myIsReversed) {
            if (this.myNext == this.myStarts[this.myIndex]) {
                --this.myIndex;
                this.myNext = this.myIndex >= 0 ? this.myEnds[this.myIndex] : -1;
            } else {
                --this.myNext;
            }
        } else if (this.myNext == this.myEnds[this.myIndex]) {
            ++this.myIndex;
            this.myNext = this.myIndex < this.myStarts.length ? this.myStarts[this.myIndex] : -1;
        } else {
            ++this.myNext;
        }
        return this.myLast;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forEachRemaining(Consumer<? super Integer> consumer) {
        while (this.hasNext()) {
            consumer.accept(this.next());
        }
    }
}

