/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.format;

import com.vladsch.flexmark.util.Ref;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.html.CellAlignment;
import com.vladsch.flexmark.util.html.FormattingAppendable;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.PrefixedSubSequence;
import com.vladsch.flexmark.util.sequence.SubSequence;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class Table {
    public final TableSection heading = new TableSection();
    public final TableSection separator = new TableSection();
    public final TableSection body = new TableSection();
    public final TableFormatOptions options;
    private BasedSequence captionOpen;
    private BasedSequence caption;
    private BasedSequence captionClose;
    private boolean isHeading = true;
    private boolean isSeparator = false;
    public CellAlignment[] alignments;
    public int[] columnWidths;

    public Table(DataHolder options) {
        this(new TableFormatOptions(options));
    }

    public Table(TableFormatOptions options) {
        this.options = options;
    }

    public boolean isHeading() {
        return this.isHeading;
    }

    public void setHeading(boolean heading) {
        this.isHeading = heading;
    }

    public boolean isSeparator() {
        return this.isSeparator;
    }

    public BasedSequence getCaptionOpen() {
        return this.captionOpen;
    }

    public BasedSequence getCaption() {
        return this.caption;
    }

    public void setCaption(CharSequence caption) {
        this.caption = BasedSequenceImpl.of(caption);
    }

    public void setCaption(CharSequence captionOpen, CharSequence caption, CharSequence captionClose) {
        this.captionOpen = BasedSequenceImpl.of(captionOpen);
        this.caption = BasedSequenceImpl.of(caption);
        this.captionClose = BasedSequenceImpl.of(captionClose);
    }

    public BasedSequence getCaptionClose() {
        return this.captionClose;
    }

    public void setSeparator(boolean separator) {
        this.isSeparator = separator;
    }

    public void nextRow() {
        if (this.isSeparator) {
            throw new IllegalStateException("Only one separator row allowed");
        }
        if (this.isHeading) {
            this.heading.nextRow();
        } else {
            this.body.nextRow();
        }
    }

    public int getHeadingRows() {
        return this.heading.rows.size();
    }

    public int getBodyRows() {
        return this.body.rows.size();
    }

    public int getHeadingColumns() {
        return this.heading.getMaxColumns();
    }

    public int getSeparatorColumns() {
        return this.body.getMaxColumns();
    }

    public int getBodyColumns() {
        return this.body.getMaxColumns();
    }

    public void addCell(TableCell cell) {
        TableSection tableSection;
        TableSection tableSection2 = this.isSeparator ? this.separator : (tableSection = this.isHeading ? this.heading : this.body);
        if (this.isSeparator && (cell.columnSpan != 1 || cell.rowSpan != 1)) {
            throw new IllegalStateException("Separator columns cannot span rows/columns");
        }
        TableRow currentRow = tableSection.get(tableSection.row);
        while (tableSection.column < currentRow.cells.size() && currentRow.cells.get(tableSection.column) != null) {
            ++tableSection.column;
        }
        block1: for (int rowSpan = 0; rowSpan < cell.rowSpan; ++rowSpan) {
            tableSection.get(tableSection.row + rowSpan).set(tableSection.column, cell);
            for (int colSpan = 1; colSpan < cell.columnSpan; ++colSpan) {
                tableSection.expandTo(tableSection.row + rowSpan, tableSection.column + colSpan);
                if (tableSection.get((int)(tableSection.row + rowSpan)).cells.get(tableSection.column + colSpan) != null) continue block1;
                tableSection.rows.get(tableSection.row + rowSpan).set(tableSection.column + colSpan, TableCell.NULL);
            }
        }
        tableSection.column += cell.columnSpan;
    }

    public int getMinColumns() {
        int headingColumns = this.heading.getMinColumns();
        int separatorColumns = this.separator.getMinColumns();
        int bodyColumns = this.body.getMinColumns();
        return Utils.min(headingColumns, separatorColumns, bodyColumns);
    }

    public int getMaxColumns() {
        int headingColumns = this.heading.getMaxColumns();
        int separatorColumns = this.separator.getMaxColumns();
        int bodyColumns = this.body.getMaxColumns();
        return Utils.max(headingColumns, separatorColumns, bodyColumns);
    }

    public BasedSequence cellText(CharSequence chars, int width, CellAlignment alignment, Ref<Integer> accumulatedDelta) {
        BasedSequence text = BasedSequenceImpl.of(chars);
        int length = this.options.charWidthProvider.charWidth(text);
        if (length < width && this.options.adjustColumnWidth) {
            if (!this.options.applyColumnAlignment || alignment == null || alignment == CellAlignment.NONE) {
                alignment = CellAlignment.LEFT;
            }
            int diff = width - length;
            int spaceCount = diff / this.options.spaceWidth;
            if ((Integer)accumulatedDelta.value * 2 >= this.options.spaceWidth) {
                ++spaceCount;
                Ref<Integer> ref = accumulatedDelta;
                ref.value = (Integer)ref.value - this.options.spaceWidth;
            }
            switch (alignment) {
                case LEFT: {
                    text = text.append(PrefixedSubSequence.repeatOf(" ", spaceCount, text.subSequence(0, 0)));
                    break;
                }
                case RIGHT: {
                    text = PrefixedSubSequence.repeatOf(" ", spaceCount, text);
                    break;
                }
                case CENTER: {
                    int count = spaceCount / 2;
                    text = PrefixedSubSequence.repeatOf(" ", count, text).append(PrefixedSubSequence.repeatOf(" ", spaceCount - count, text.subSequence(0, 0)));
                }
            }
        }
        return text;
    }

    public int spanWidth(int col, int colSpan) {
        if (colSpan > 1) {
            int width = 0;
            for (int i = 0; i < colSpan; ++i) {
                width += this.columnWidths[i + col];
            }
            return width;
        }
        return this.columnWidths[col];
    }

    public int spanFixedWidth(BitSet unfixedColumns, int col, int colSpan) {
        if (colSpan > 1) {
            int width = 0;
            for (int i = 0; i < colSpan; ++i) {
                if (unfixedColumns.get(i)) continue;
                width += this.columnWidths[i + col];
            }
            return width;
        }
        return this.columnWidths[col];
    }

    private CellAlignment adjustCellAlignment(CellAlignment alignment) {
        switch (this.options.leftAlignMarker) {
            case ADD: {
                if (alignment != null && alignment != CellAlignment.NONE) break;
                alignment = CellAlignment.LEFT;
                break;
            }
            case REMOVE: {
                if (alignment != CellAlignment.LEFT) break;
                alignment = CellAlignment.NONE;
                break;
            }
        }
        return alignment;
    }

    public void finalizeTable() {
        int j;
        int width;
        BasedSequence cellText;
        int maxColumns;
        int minColumns;
        this.heading.cleanup();
        this.body.cleanup();
        if (this.options.fillMissingColumns && (minColumns = this.getMinColumns()) < (maxColumns = this.getMaxColumns())) {
            TableCell empty = new TableCell("", 1, 1);
            for (TableRow row : this.heading.rows) {
                row.expandTo(maxColumns - 1, empty);
            }
            for (TableRow row : this.body.rows) {
                row.expandTo(maxColumns - 1, empty);
            }
        }
        int sepColumns = this.getMaxColumns();
        this.alignments = new CellAlignment[sepColumns];
        this.columnWidths = new int[sepColumns];
        BitSet spanAlignment = new BitSet(sepColumns);
        ArrayList<ColumnSpan> columnSpans = new ArrayList<ColumnSpan>();
        Ref<Integer> delta = new Ref<Integer>(0);
        if (this.separator.rows.size() > 0) {
            TableRow row;
            row = this.separator.rows.get(0);
            int j2 = 0;
            int jSpan = 0;
            delta.value = 0;
            for (TableCell cell : row.cells) {
                if ((this.alignments[jSpan] == null || cell.columnSpan == 1 && spanAlignment.get(jSpan)) && cell.alignment != CellAlignment.NONE) {
                    this.alignments[jSpan] = cell.alignment;
                    if (cell.columnSpan > 1) {
                        spanAlignment.set(jSpan);
                    }
                }
                ++j2;
                jSpan += cell.columnSpan;
            }
        }
        if (this.heading.rows.size() > 0) {
            int i = 0;
            for (TableRow row : this.heading.rows) {
                int j3 = 0;
                int jSpan = 0;
                delta.value = 0;
                for (TableCell cell : row.cells) {
                    if ((this.alignments[jSpan] == null || cell.columnSpan == 1 && spanAlignment.get(jSpan)) && cell.alignment != CellAlignment.NONE) {
                        this.alignments[jSpan] = cell.alignment;
                        if (cell.columnSpan > 1) {
                            spanAlignment.set(jSpan);
                        }
                    }
                    cellText = this.cellText(cell.text, 0, null, delta);
                    width = this.options.charWidthProvider.charWidth(cellText) + this.options.spacePad + this.options.pipeWidth * cell.columnSpan;
                    if (cell.columnSpan > 1) {
                        columnSpans.add(new ColumnSpan(j3, cell.columnSpan, width));
                    } else if (this.columnWidths[jSpan] < width) {
                        this.columnWidths[jSpan] = width;
                    }
                    ++j3;
                    jSpan += cell.columnSpan;
                }
                ++i;
            }
        }
        if (this.body.rows.size() > 0) {
            int i = 0;
            delta.value = 0;
            for (TableRow row : this.body.rows) {
                int j4 = 0;
                int jSpan = 0;
                for (TableCell cell : row.cells) {
                    cellText = this.cellText(cell.text, 0, null, delta);
                    width = this.options.charWidthProvider.charWidth(cellText) + this.options.spacePad + this.options.pipeWidth * cell.columnSpan;
                    if (cell.columnSpan > 1) {
                        columnSpans.add(new ColumnSpan(jSpan, cell.columnSpan, width));
                    } else if (this.columnWidths[jSpan] < width) {
                        this.columnWidths[jSpan] = width;
                    }
                    ++j4;
                    jSpan += cell.columnSpan;
                }
                ++i;
            }
        }
        if (this.separator.rows.size() == 0 || this.body.rows.size() > 0 || this.heading.rows.size() > 0) {
            j = 0;
            delta.value = 0;
            CellAlignment[] j2 = this.alignments;
            int row = j2.length;
            for (int j4 = 0; j4 < row; ++j4) {
                int width2;
                int dashCount = 0;
                CellAlignment alignment = j2[j4];
                CellAlignment alignment1 = this.adjustCellAlignment(alignment);
                int colonCount = alignment1 == CellAlignment.LEFT || alignment1 == CellAlignment.RIGHT ? 1 : (alignment1 == CellAlignment.CENTER ? 2 : 0);
                int dashesOnly = Utils.minLimit(dashCount, this.options.minSeparatorColumnWidth - colonCount, this.options.minSeparatorDashes);
                if (dashCount < dashesOnly) {
                    dashCount = dashesOnly;
                }
                if (this.columnWidths[j] < (width2 = dashCount * this.options.dashWidth + colonCount * this.options.colonWidth + this.options.pipeWidth)) {
                    this.columnWidths[j] = width2;
                }
                ++j;
            }
        } else {
            j = 0;
            delta.value = 0;
            for (TableCell cell : this.separator.rows.get((int)0).cells) {
                int width3;
                int dashesOnly;
                CellAlignment alignment = this.adjustCellAlignment(cell.alignment);
                int colonCount = alignment == CellAlignment.LEFT || alignment == CellAlignment.RIGHT ? 1 : (alignment == CellAlignment.CENTER ? 2 : 0);
                int dashCount = cell.text.trim(":").length();
                if (dashCount < (dashesOnly = Utils.minLimit(dashCount, this.options.minSeparatorColumnWidth - colonCount, this.options.minSeparatorDashes))) {
                    dashCount = dashesOnly;
                }
                if (this.columnWidths[j] < (width3 = dashCount * this.options.dashWidth + colonCount * this.options.colonWidth + this.options.pipeWidth)) {
                    this.columnWidths[j] = width3;
                }
                ++j;
            }
        }
        if (!columnSpans.isEmpty()) {
            int[] additionalWidths = new int[sepColumns];
            BitSet unfixedColumns = new BitSet(sepColumns);
            ArrayList<ColumnSpan> newColumnSpans = new ArrayList<ColumnSpan>(columnSpans.size());
            for (ColumnSpan columnSpan : columnSpans) {
                int spanWidth = this.spanWidth(columnSpan.startColumn, columnSpan.columnSpan);
                if (spanWidth >= columnSpan.width) continue;
                unfixedColumns.set(columnSpan.startColumn, columnSpan.startColumn + columnSpan.columnSpan);
                newColumnSpans.add(columnSpan);
            }
            while (!newColumnSpans.isEmpty()) {
                int fixedWidth;
                int spanWidth;
                columnSpans = newColumnSpans;
                BitSet fixedColumns = new BitSet(sepColumns);
                newColumnSpans.clear();
                for (ColumnSpan columnSpan : columnSpans) {
                    spanWidth = this.spanWidth(columnSpan.startColumn, columnSpan.columnSpan);
                    if (spanWidth <= (fixedWidth = this.spanFixedWidth(unfixedColumns, columnSpan.startColumn, columnSpan.columnSpan))) {
                        fixedColumns.set(columnSpan.startColumn, columnSpan.startColumn + columnSpan.columnSpan);
                        continue;
                    }
                    newColumnSpans.add(columnSpan);
                }
                unfixedColumns.andNot(fixedColumns);
                columnSpans = newColumnSpans;
                newColumnSpans.clear();
                for (ColumnSpan columnSpan : columnSpans) {
                    spanWidth = this.spanWidth(columnSpan.startColumn, columnSpan.columnSpan);
                    if (spanWidth <= (fixedWidth = this.spanFixedWidth(unfixedColumns, columnSpan.startColumn, columnSpan.columnSpan))) continue;
                    int distributeWidth = spanWidth - fixedWidth;
                    int unfixedColumnCount = unfixedColumns.get(columnSpan.startColumn, columnSpan.startColumn + columnSpan.columnSpan).cardinality();
                    int perSpanWidth = distributeWidth / unfixedColumnCount;
                    int extraWidth = distributeWidth - perSpanWidth * unfixedColumnCount;
                    for (int i = 0; i < columnSpan.columnSpan; ++i) {
                        if (!unfixedColumns.get(columnSpan.startColumn + i)) continue;
                        int n = columnSpan.startColumn + i;
                        this.columnWidths[n] = this.columnWidths[n] + perSpanWidth;
                        if (extraWidth <= 0) continue;
                        int n2 = columnSpan.startColumn + i;
                        this.columnWidths[n2] = this.columnWidths[n2] + 1;
                        --extraWidth;
                    }
                    newColumnSpans.add(columnSpan);
                }
            }
        }
    }

    public void appendTable(FormattingAppendable out) {
        int jSpan;
        int j;
        int formatterOptions = out.getOptions();
        out.setOptions(formatterOptions & 0xFFFFFFFD);
        Ref<Integer> delta = new Ref<Integer>(0);
        if (this.heading.rows.size() > 0) {
            for (TableRow tableRow : this.heading.rows) {
                j = 0;
                jSpan = 0;
                delta.value = 0;
                for (TableCell cell : tableRow.cells) {
                    if (j == 0) {
                        if (this.options.leadTrailPipes) {
                            out.append('|');
                            if (this.options.spaceAroundPipes) {
                                out.append(' ');
                            }
                        }
                    } else if (this.options.spaceAroundPipes) {
                        out.append(' ');
                    }
                    CellAlignment cellAlignment = cell.alignment != CellAlignment.NONE ? cell.alignment : this.alignments[jSpan];
                    out.append(this.cellText(cell.text, this.spanWidth(jSpan, cell.columnSpan) - this.options.spacePad - this.options.pipeWidth * cell.columnSpan, cellAlignment, delta));
                    jSpan += cell.columnSpan;
                    if (++j < this.alignments.length) {
                        if (this.options.spaceAroundPipes) {
                            out.append(' ');
                        }
                        out.repeat('|', cell.columnSpan);
                        continue;
                    }
                    if (this.options.leadTrailPipes) {
                        if (this.options.spaceAroundPipes) {
                            out.append(' ');
                        }
                        out.repeat('|', cell.columnSpan);
                        continue;
                    }
                    if (this.options.spaceAroundPipes) {
                        out.append(' ');
                    }
                    out.repeat('|', cell.columnSpan - 1);
                }
                if (j <= 0) continue;
                out.line();
            }
        }
        int j2 = 0;
        delta.value = 0;
        for (CellAlignment alignment : this.alignments) {
            int dashesOnly;
            CellAlignment alignment1 = this.adjustCellAlignment(alignment);
            int colonCount = alignment1 == CellAlignment.LEFT || alignment1 == CellAlignment.RIGHT ? 1 : (alignment1 == CellAlignment.CENTER ? 2 : 0);
            int dashCount = (this.columnWidths[j2] - colonCount * this.options.colonWidth - this.options.pipeWidth) / this.options.dashWidth;
            if (dashCount < (dashesOnly = Utils.minLimit(dashCount, this.options.minSeparatorColumnWidth - colonCount, this.options.minSeparatorDashes))) {
                dashCount = dashesOnly;
            }
            if ((Integer)delta.value * 2 >= this.options.dashWidth) {
                ++dashCount;
                Ref<Integer> ref = delta;
                Integer.valueOf((Integer)ref.value - this.options.dashWidth);
                ref.value = ref.value;
            }
            if (this.options.leadTrailPipes && j2 == 0) {
                out.append('|');
            }
            if (alignment1 == CellAlignment.LEFT || alignment1 == CellAlignment.CENTER) {
                out.append(':');
            }
            out.repeat('-', dashCount);
            if (alignment1 == CellAlignment.RIGHT || alignment1 == CellAlignment.CENTER) {
                out.append(':');
            }
            if (!this.options.leadTrailPipes && ++j2 >= this.alignments.length) continue;
            out.append('|');
        }
        out.line();
        if (this.body.rows.size() > 0) {
            for (TableRow tableRow : this.body.rows) {
                j = 0;
                jSpan = 0;
                delta.value = 0;
                for (TableCell cell : tableRow.cells) {
                    if (j == 0) {
                        if (this.options.leadTrailPipes) {
                            out.append('|');
                            if (this.options.spaceAroundPipes) {
                                out.append(' ');
                            }
                        }
                    } else if (this.options.spaceAroundPipes) {
                        out.append(' ');
                    }
                    out.append(this.cellText(cell.text, this.spanWidth(jSpan, cell.columnSpan) - this.options.spacePad - this.options.pipeWidth * cell.columnSpan, this.alignments[jSpan], delta));
                    jSpan += cell.columnSpan;
                    if (++j < this.alignments.length) {
                        if (this.options.spaceAroundPipes) {
                            out.append(' ');
                        }
                        out.repeat('|', cell.columnSpan);
                        continue;
                    }
                    if (this.options.leadTrailPipes) {
                        if (this.options.spaceAroundPipes) {
                            out.append(' ');
                        }
                        out.repeat('|', cell.columnSpan);
                        continue;
                    }
                    if (this.options.spaceAroundPipes) {
                        out.append(' ');
                    }
                    out.repeat('|', cell.columnSpan - 1);
                }
                if (j <= 0) continue;
                out.line();
            }
        }
        out.setOptions(formatterOptions);
        if (this.caption != null && !this.options.removeCaption) {
            out.line().append('[').append(this.caption).append(']').line();
        }
    }

    public static class TableSection {
        public final List<TableRow> rows = new ArrayList<TableRow>();
        public int row = 0;
        public int column = 0;

        public void nextRow() {
            ++this.row;
            this.column = 0;
        }

        public void setCell(int row, int column, TableCell cell) {
            this.expandTo(row).set(column, cell);
        }

        public void cleanup() {
            for (TableRow row : this.rows) {
                row.cleanup();
            }
        }

        public TableRow expandTo(int row) {
            return this.expandTo(row, null);
        }

        public TableRow expandTo(int row, TableCell cell) {
            while (row >= this.rows.size()) {
                TableRow tableRow = new TableRow();
                this.rows.add(tableRow);
            }
            return this.rows.get(row);
        }

        public TableRow expandTo(int row, int column) {
            return this.expandTo(row, column, null);
        }

        public TableRow expandTo(int row, int column, TableCell cell) {
            while (row >= this.rows.size()) {
                TableRow tableRow = new TableRow();
                tableRow.expandTo(column, cell);
                this.rows.add(tableRow);
            }
            return this.rows.get(row).expandTo(column);
        }

        public TableRow get(int row) {
            return this.expandTo(row, null);
        }

        public int getMaxColumns() {
            int columns = 0;
            for (TableRow row : this.rows) {
                int spans = row.getSpannedColumns();
                if (columns >= spans) continue;
                columns = spans;
            }
            return columns;
        }

        public int getMinColumns() {
            int columns = 0;
            for (TableRow row : this.rows) {
                int spans = row.getSpannedColumns();
                if (columns <= spans && columns != 0) continue;
                columns = spans;
            }
            return columns;
        }
    }

    public static class TableRow {
        public final List<TableCell> cells = new ArrayList<TableCell>();

        TableRow() {
        }

        public int getColumns() {
            return this.cells.size();
        }

        public int getSpannedColumns() {
            int columns = 0;
            for (TableCell cell : this.cells) {
                if (cell == null) continue;
                columns += cell.columnSpan;
            }
            return columns;
        }

        public TableRow expandTo(int column) {
            return this.expandTo(column, null);
        }

        public TableRow expandTo(int column, TableCell cell) {
            while (column >= this.cells.size()) {
                this.cells.add(cell);
            }
            return this;
        }

        public void set(int column, TableCell cell) {
            this.expandTo(column, null);
            this.cells.set(column, cell);
        }

        public void cleanup() {
            int column = 0;
            while (column < this.cells.size()) {
                TableCell cell = this.cells.get(column);
                if (cell == null || cell == TableCell.NULL) {
                    this.cells.remove(column);
                    continue;
                }
                ++column;
            }
        }
    }

    public static class TableCell {
        public static final TableCell NULL = new TableCell(SubSequence.NULL, " ", BasedSequence.NULL, 1, 0, CellAlignment.NONE);
        public final BasedSequence openMarker;
        public final BasedSequence text;
        public final BasedSequence closeMarker;
        public final int columnSpan;
        public final int rowSpan;
        public final CellAlignment alignment;

        public TableCell(CharSequence text, int rowSpan, int columnSpan) {
            this(BasedSequence.NULL, text, BasedSequence.NULL, rowSpan, columnSpan, CellAlignment.NONE);
        }

        public TableCell(CharSequence text, int rowSpan, int columnSpan, CellAlignment alignment) {
            this(BasedSequence.NULL, text, BasedSequence.NULL, rowSpan, columnSpan, alignment);
        }

        public TableCell(CharSequence openMarker, CharSequence text, CharSequence closeMarker, int rowSpan, int columnSpan) {
            this(openMarker, text, closeMarker, rowSpan, columnSpan, CellAlignment.NONE);
        }

        public TableCell(CharSequence openMarker, CharSequence text, CharSequence closeMarker, int rowSpan, int columnSpan, CellAlignment alignment) {
            BasedSequence chars = BasedSequenceImpl.of(text);
            this.openMarker = BasedSequenceImpl.of(openMarker);
            this.text = chars.isEmpty() ? BasedSequence.SPACE : chars;
            this.closeMarker = BasedSequenceImpl.of(closeMarker);
            this.rowSpan = rowSpan;
            this.columnSpan = columnSpan;
            this.alignment = alignment != null ? alignment : CellAlignment.NONE;
        }
    }

    private static class ColumnSpan {
        final int startColumn;
        final int columnSpan;
        final int width;
        int additionalWidth;

        public ColumnSpan(int startColumn, int columnSpan, int width) {
            this.startColumn = startColumn;
            this.columnSpan = columnSpan;
            this.width = width;
            this.additionalWidth = 0;
        }
    }
}

