/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.tree.iteration;

import com.vladsch.flexmark.tree.iteration.IterationConditions;
import com.vladsch.flexmark.tree.iteration.IteratorInstance;
import com.vladsch.flexmark.tree.iteration.ValueIteration;
import com.vladsch.flexmark.tree.iteration.ValueIterationAdapter;
import com.vladsch.flexmark.tree.iteration.ValueIterationConsumer;
import com.vladsch.flexmark.tree.iteration.VoidIteration;
import com.vladsch.flexmark.tree.iteration.VoidIterationConsumer;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeIterator<N> {
    public static final Logger LOG = LoggerFactory.getILoggerFactory().getLogger("com.vladsch.treeIteration.util.looping");
    public static final Logger LOG_INFO = LoggerFactory.getILoggerFactory().getLogger("com.vladsch.treeIteration.util.looping-summary");
    public static final Logger LOG_TRACE = LoggerFactory.getILoggerFactory().getLogger("com.vladsch.treeIteration.util.looping-detailed");
    public static final Predicate<Object> TRUE = o -> true;
    public static final Predicate<Object> FALSE = o -> false;
    public static final Predicate<Object> NOT_NULL = Objects::nonNull;
    private final IterationConditions<N> myConstraints;
    private final Predicate<? super N> myRecursion;
    protected final Predicate<? super N> myFilter;

    public TreeIterator(IterationConditions<N> constraints, Predicate<? super N> filter) {
        this(constraints, filter, FALSE);
    }

    public TreeIterator(IterationConditions<N> constraints) {
        this(constraints, TRUE, FALSE);
    }

    public TreeIterator(IterationConditions<N> constraints, Predicate<? super N> filter, Predicate<? super N> recursion) {
        this.myConstraints = constraints;
        this.myRecursion = recursion;
        this.myFilter = filter;
    }

    @NotNull
    public Predicate<N> getPredicate(@NotNull Class<? super N> clazz) {
        return clazz::isInstance;
    }

    @NotNull
    public <F> Predicate<N> getPredicate(@NotNull Class<F> clazz, @NotNull Predicate<? super F> predicate) {
        return it -> clazz.isInstance(it) && predicate.test((Object)clazz.cast(it));
    }

    @NotNull
    public IterationConditions<N> getConstraints() {
        return this.myConstraints;
    }

    public Predicate<? super N> getRecursion() {
        return this.myRecursion;
    }

    public Predicate<? super N> getFilter() {
        return this.myFilter;
    }

    @NotNull
    public TreeIterator<N> modifiedCopy(@NotNull IterationConditions<N> constraints, @NotNull Predicate<? super N> filter, @NotNull Predicate<? super N> recursion) {
        return new TreeIterator<N>(constraints, filter, recursion);
    }

    @NotNull
    public TreeIterator<N> reversed() {
        return this.modifiedCopy(this.myConstraints.getReversed(), this.myFilter, this.myRecursion);
    }

    @NotNull
    public TreeIterator<N> recursive() {
        return this.modifiedCopy(this.myConstraints, this.myFilter, TRUE);
    }

    @NotNull
    public TreeIterator<N> nonRecursive() {
        return this.modifiedCopy(this.myConstraints, this.myFilter, FALSE);
    }

    @NotNull
    public TreeIterator<N> recurse(@NotNull Predicate<? super N> predicate) {
        return this.modifiedCopy(this.myConstraints, this.myFilter, it -> this.myRecursion.test(it) || predicate.test((N)it));
    }

    @NotNull
    public TreeIterator<N> recurse(@NotNull Class<? super N> clazz) {
        return this.recurse(this.getPredicate(clazz));
    }

    @NotNull
    public <F> TreeIterator<N> recurse(@NotNull Class<F> clazz, @NotNull Predicate<? super F> predicate) {
        return this.recurse(this.getPredicate(clazz, predicate));
    }

    @NotNull
    public TreeIterator<N> noRecurse(@NotNull Predicate<? super N> predicate) {
        return this.modifiedCopy(this.myConstraints, this.myFilter, it -> this.myRecursion.test(it) && !predicate.test((N)it));
    }

    @NotNull
    public TreeIterator<N> noRecurse(@NotNull Class<? super N> clazz) {
        return this.noRecurse(this.getPredicate(clazz));
    }

    @NotNull
    public <F> TreeIterator<N> noRecurse(@NotNull Class<F> clazz, @NotNull Predicate<? super F> predicate) {
        return this.noRecurse(this.getPredicate(clazz, predicate));
    }

    @NotNull
    public TreeIterator<N> aborted() {
        return this.modifiedCopy(this.myConstraints.getAborted(), this.myFilter, this.myRecursion);
    }

    @NotNull
    public TreeIterator<N> filterOut(@NotNull Predicate<? super N> predicate) {
        return this.modifiedCopy(this.myConstraints, it -> this.myFilter.test(it) && !predicate.test((N)it), this.myRecursion);
    }

    @NotNull
    public TreeIterator<N> filterOut(@NotNull Class<? super N> clazz) {
        return this.filterOut(this.getPredicate(clazz));
    }

    @NotNull
    public <F> TreeIterator<N> filterOut(@NotNull Class<F> clazz, @NotNull Predicate<? super F> predicate) {
        return this.filterOut(this.getPredicate(clazz, predicate));
    }

    @NotNull
    public TreeIterator<N> filter(@NotNull Predicate<? super N> predicate) {
        return this.modifiedCopy(this.myConstraints, it -> this.myFilter.test(it) && predicate.test((N)it), this.myRecursion);
    }

    @NotNull
    public TreeIterator<N> filter(@NotNull Class<? super N> clazz) {
        return this.filter(this.getPredicate(clazz));
    }

    @NotNull
    public <F> TreeIterator<N> filter(@NotNull Class<F> clazz, @NotNull Predicate<? super F> predicate) {
        return this.filter(this.getPredicate(clazz, predicate));
    }

    @NotNull
    public static <N> TreeIterator<N> of(@NotNull IterationConditions<N> constraints) {
        return new TreeIterator<N>(constraints);
    }

    @NotNull
    public static <N> TreeIterator<N> of(@NotNull IterationConditions<N> constraints, @NotNull Predicate<? super N> filter) {
        return new TreeIterator<N>(constraints, filter);
    }

    @NotNull
    public static <N> TreeIterator<N> of(@NotNull IterationConditions<N> constraints, @NotNull Predicate<? super N> filter, @NotNull Predicate<? super N> recursion) {
        return new TreeIterator<N>(constraints, filter, recursion);
    }

    @NotNull
    public static <N> Predicate<N> TRUE() {
        return n -> true;
    }

    @NotNull
    public static <N> Predicate<N> FALSE() {
        return n -> true;
    }

    public <R> ValueIteration<R> iterate(@NotNull N element, @NotNull R defaultValue, @NotNull ValueIterationConsumer<? super N, R> consumer) {
        IteratorInstance<? super N, R> instance = new IteratorInstance<N, R>(this.getConstraints(), this.getFilter(), this.getRecursion(), element, defaultValue);
        instance.iterate(consumer);
        return instance;
    }

    public <T, R> ValueIteration<R> iterate(@NotNull N element, @NotNull R defaultValue, @NotNull ValueIterationAdapter<? super N, T> adapter, @NotNull ValueIterationConsumer<? super T, R> consumer) {
        IteratorInstance<? super N, R> instance = new IteratorInstance<N, R>(this.getConstraints(), this.getFilter(), this.getRecursion(), element, defaultValue);
        instance.iterate(adapter.getConsumerAdapter().getConsumer(consumer));
        return instance;
    }

    public <R> VoidIteration iterate(@NotNull N element, @NotNull VoidIterationConsumer<? super N> consumer) {
        IteratorInstance instance = new IteratorInstance(this.getConstraints(), this.getFilter(), this.getRecursion(), element);
        instance.iterate(consumer);
        return instance;
    }

    public <T, R> VoidIteration iterate(@NotNull N element, @NotNull ValueIterationAdapter<? super N, T> adapter, @NotNull VoidIterationConsumer<? super T> consumer) {
        IteratorInstance instance = new IteratorInstance(this.getConstraints(), this.getFilter(), this.getRecursion(), element);
        instance.iterate(adapter.getConsumerAdapter().getConsumer(consumer));
        return instance;
    }

    @NotNull
    public <R> R doLoop(@NotNull N element, @NotNull R defaultValue, @NotNull ValueIterationConsumer<? super N, R> consumer) {
        return this.iterate(element, defaultValue, consumer).getResult();
    }

    public void doLoop(@NotNull N element, @NotNull VoidIterationConsumer<? super N> consumer) {
        this.iterate(element, consumer);
    }

    @NotNull
    public <T, R> R doLoop(@NotNull N element, @NotNull R defaultValue, @NotNull ValueIterationAdapter<? super N, T> adapter, @NotNull ValueIterationConsumer<? super T, R> consumer) {
        return this.iterate(element, defaultValue, adapter, consumer).getResult();
    }

    public <T, R> void doLoop(@NotNull N element, @NotNull ValueIterationAdapter<? super N, T> adapter, @NotNull VoidIterationConsumer<? super T> consumer) {
        this.iterate(element, adapter, consumer);
    }
}

