/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.tree.iteration;

import com.vladsch.flexmark.tree.iteration.IterationConditions;
import com.vladsch.flexmark.tree.iteration.TreeIterator;
import com.vladsch.flexmark.tree.iteration.ValueIteration;
import com.vladsch.flexmark.tree.iteration.ValueIterationConsumer;
import com.vladsch.flexmark.tree.iteration.VoidIteration;
import com.vladsch.flexmark.tree.iteration.VoidIterationConsumer;
import com.vladsch.flexmark.tree.iteration.VoidToValueIConsumerAdapter;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.util.Stack;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class IteratorInstance<N, R>
implements ValueIteration<R> {
    private static final Logger LOG_INFO = TreeIterator.LOG_INFO;
    private static final Logger LOG_TRACE = TreeIterator.LOG_TRACE;
    private Iteration<N> myIteration;
    @Nullable
    private Stack<Iteration<N>> myRecursions;
    @NotNull
    private final IterationConditions<N> myIterationConditions;
    @NotNull
    private final Predicate<? super N> myRecursionPredicate;
    @NotNull
    private final Predicate<? super N> myFilterPredicate;
    private int myTotalLoopCount = 0;
    private int myTotalAcceptCount = 0;
    @Nullable
    private N myMatch;
    @Nullable
    private MutableDataSet myDataSet;
    @NotNull
    private final Object myDefaultValue;
    @NotNull
    private Object myResult;
    private boolean myBreak = false;
    private boolean myHadRecurse = false;
    private boolean myIsDefaultResult = true;
    private int myMaxRecursions = 0;

    public IteratorInstance(@NotNull IterationConditions<N> iterationConditions, @NotNull Predicate<? super N> filterPredicate, @NotNull Predicate<? super N> recursionPredicate, @NotNull N element) {
        this((IterationConditions<? super N>)iterationConditions, filterPredicate, recursionPredicate, (N)element, VoidIteration.NULL);
    }

    public IteratorInstance(@NotNull IterationConditions<N> iterationConditions, @NotNull Predicate<? super N> filterPredicate, @NotNull Predicate<? super N> recursionPredicate, @NotNull N element, @NotNull Object defaultValue) {
        this.myIterationConditions = iterationConditions;
        this.myRecursionPredicate = recursionPredicate;
        this.myFilterPredicate = filterPredicate;
        this.myIteration = new Iteration<N>(this.myIterationConditions.getInitializer().apply(element));
        this.myDefaultValue = defaultValue;
        this.myResult = defaultValue;
    }

    public void iterate(@NotNull VoidIterationConsumer<? super N> consumer) {
        this.iterate(new VoidToValueIConsumerAdapter(consumer));
    }

    public void iterate(@NotNull ValueIterationConsumer<? super N, R> consumer) {
        consumer.beforeStart(this);
        if (LOG_INFO.isDebugEnabled()) {
            LOG_INFO.debug("Starting looping " + this.myIteration);
        }
        if (LOG_INFO.isDebugEnabled()) {
            LOG_INFO.debug("Start recursion " + this.getRecursionLevel());
        }
        while (true) {
            if (this.myIteration.next == null) {
                if (LOG_INFO.isDebugEnabled()) {
                    LOG_INFO.debug("End recursion " + this.getRecursionLevel());
                }
                consumer.endRecursion(this);
                if (this.myRecursions == null || this.myRecursions.size() == 0) break;
                this.dropRecursions(1, false);
                if (LOG_INFO.isDebugEnabled()) {
                    LOG_INFO.debug("Start recursion " + this.getRecursionLevel());
                }
                consumer.startRecursion(this);
                continue;
            }
            this.myIteration.advance(this.myIterationConditions.getIterator().apply(this.myIteration.next));
            ++this.myTotalLoopCount;
            this.myMatch = this.myIteration.current;
            if (this.myMatch == null) continue;
            if (this.myFilterPredicate.test(this.myMatch)) {
                ++this.myIteration.acceptCount;
                ++this.myTotalAcceptCount;
                this.myHadRecurse = false;
                consumer.accept(this.myMatch, this);
                if (LOG_TRACE.isDebugEnabled()) {
                    LOG_TRACE.debug("Consumed, recursion: " + this.getRecursionLevel() + " isBreak " + this.myBreak + " recursed: " + this.myHadRecurse + " " + this.myIteration);
                }
                if (this.myBreak) {
                    break;
                }
            } else if (LOG_TRACE.isDebugEnabled()) {
                LOG_TRACE.debug("Skipping, recursion: " + this.getRecursionLevel() + " filtered out " + this.myIteration);
            }
            if (this.myHadRecurse || this.myMatch == null || !this.myRecursionPredicate.test(this.myMatch)) continue;
            if (LOG_TRACE.isDebugEnabled()) {
                LOG_TRACE.debug("Recursing " + this.myIteration);
            }
            this.Recurse();
            if (LOG_INFO.isDebugEnabled()) {
                LOG_INFO.debug("Start recursion " + this.getRecursionLevel());
            }
            consumer.startRecursion(this);
        }
        consumer.afterEnd(this);
        if (LOG_INFO.isDebugEnabled()) {
            LOG_INFO.debug("Done looping, totalLoopCount: " + this.myTotalLoopCount + " totalCount: " + this.myTotalAcceptCount + " maxRecursions: " + this.myMaxRecursions + " " + this.myIteration);
        }
    }

    @Override
    public boolean getHaveNext() {
        return this.myIteration.next != null;
    }

    @Override
    public boolean getHaveAcceptableNext() {
        return this.myIteration.next != null && this.myFilterPredicate.test(this.myIteration.next);
    }

    @Override
    public void setResult(@NotNull Object value) {
        this.myResult = value;
        this.myIsDefaultResult = false;
    }

    @Override
    @NotNull
    public R getResult() {
        return (R)this.myResult;
    }

    @Override
    public void Return(@NotNull Object value) {
        this.myResult = value;
        this.myBreak = true;
        this.myMatch = null;
        this.myIsDefaultResult = false;
    }

    private void Recurse() {
        if (this.myMatch != null && !this.myHadRecurse) {
            if (this.myRecursions == null) {
                this.myRecursions = new Stack();
            }
            this.myHadRecurse = true;
            this.myRecursions.push(this.myIteration);
            this.myIteration = new Iteration<N>(this.myIterationConditions.getInitializer().apply(this.myMatch));
            this.myMaxRecursions = Integer.max(this.myMaxRecursions, this.myRecursions.size());
            this.myMatch = null;
        }
    }

    @Override
    public void doReturn() {
        this.myBreak = true;
        this.myMatch = null;
    }

    private void dropRecursions(int iteration, boolean inclusive) {
        if (inclusive) {
            ++iteration;
        }
        if (iteration > 0) {
            if (this.myRecursions == null || iteration > this.myRecursions.size()) {
                throw new IllegalArgumentException("Recursion level " + this.getRecursionLevel() + " is less than requested break/continue level " + iteration);
            }
            int i = iteration;
            while (i-- > 0) {
                this.myIteration = this.myRecursions.pop();
            }
        }
    }

    @Override
    public void doContinue(int recursionLevel) {
        if (this.myHadRecurse) {
            throw new IllegalStateException("Continue(" + recursionLevel + ") called after Recurse() in current iteration");
        }
        this.dropRecursions(recursionLevel, false);
        this.myMatch = null;
    }

    @Override
    public void doBreak(int recursionLevel) {
        if (this.myHadRecurse) {
            throw new IllegalStateException("Break(" + recursionLevel + ") called after Recurse() in current iteration");
        }
        if (recursionLevel == this.getRecursionLevel()) {
            this.myBreak = true;
        } else {
            this.dropRecursions(recursionLevel, true);
        }
        this.myMatch = null;
    }

    @Override
    public MutableDataHolder getData() {
        if (this.myDataSet == null) {
            this.myDataSet = new MutableDataSet();
        }
        return this.myDataSet;
    }

    @Nullable
    public N getMatch() {
        return this.myMatch;
    }

    @Override
    public boolean isComplete() {
        return this.myMatch == null;
    }

    @Override
    public boolean isIncomplete() {
        return this.myMatch != null;
    }

    @Override
    public void ifIncomplete(@NotNull Runnable runnable) {
        if (this.isIncomplete()) {
            runnable.run();
        }
    }

    @Override
    public void doComplete() {
        this.myMatch = null;
    }

    @Override
    public boolean isTerminated() {
        return this.myBreak;
    }

    @Override
    public int getLoopCount() {
        return this.myIteration.loopCount;
    }

    @Override
    public int getAcceptCount() {
        return this.myIteration.acceptCount;
    }

    @Override
    public int getTotalLoopCount() {
        return this.myTotalLoopCount;
    }

    @Override
    public int getTotalAcceptCount() {
        return this.myTotalAcceptCount;
    }

    @Override
    public int getRecursionLevel() {
        return this.myRecursions == null ? 0 : this.myRecursions.size();
    }

    @Override
    public boolean isDefaultResult() {
        return this.myIsDefaultResult;
    }

    @Override
    @NotNull
    public R getDefaultValue() {
        return (R)this.myDefaultValue;
    }

    public static class Iteration<V> {
        @Nullable
        V current;
        @Nullable
        V next;
        int acceptCount;
        int loopCount;

        Iteration(@Nullable V next) {
            this.next = next;
            this.current = next;
            this.acceptCount = 0;
            this.loopCount = 0;
        }

        void advance(@Nullable V nextValue) {
            this.current = this.next;
            this.next = nextValue;
            ++this.loopCount;
        }

        public String toString() {
            String currentText = this.current == null ? "null" : this.current.toString();
            String nextText = this.next == null ? "null" : this.next.toString();
            return "Iteration {, count=" + this.acceptCount + ", current=" + currentText.subSequence(0, Integer.min(currentText.length(), 30)) + ", next=" + nextText.subSequence(0, Integer.min(nextText.length(), 30)) + ", loopCount=" + this.loopCount + '}';
        }
    }
}

