/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test.util;

import com.vladsch.flexmark.test.util.SpecExampleParse;
import com.vladsch.flexmark.test.util.SpecExampleProcessor;
import com.vladsch.flexmark.test.util.SpecExampleRenderer;
import com.vladsch.flexmark.test.util.TestUtils;
import com.vladsch.flexmark.test.util.spec.SpecExample;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.SharedDataKeys;
import com.vladsch.flexmark.util.misc.Extension;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.junit.Rule;
import org.junit.rules.ExpectedException;

public abstract class RenderingTestCase
implements SpecExampleProcessor {
    public static final DataKey<Boolean> IGNORE = TestUtils.IGNORE;
    public static final DataKey<Boolean> FAIL = TestUtils.FAIL;
    public static final DataKey<Boolean> NO_FILE_EOL = TestUtils.NO_FILE_EOL;
    public static final DataKey<Integer> TIMED_ITERATIONS = TestUtils.TIMED_ITERATIONS;
    public static final DataKey<Boolean> EMBED_TIMED = TestUtils.EMBED_TIMED;
    public static final DataKey<Boolean> TIMED = TestUtils.TIMED;
    public static final DataKey<String> INCLUDED_DOCUMENT = TestUtils.INCLUDED_DOCUMENT;
    public static final DataKey<String> SOURCE_PREFIX = TestUtils.SOURCE_PREFIX;
    public static final DataKey<String> SOURCE_SUFFIX = TestUtils.SOURCE_SUFFIX;
    public static final DataKey<String> SOURCE_INDENT = TestUtils.SOURCE_INDENT;
    public static final DataHolder NO_FILE_EOL_FALSE = TestUtils.NO_FILE_EOL_FALSE;
    public static final DataKey<Collection<Class<? extends Extension>>> UNLOAD_EXTENSIONS = TestUtils.UNLOAD_EXTENSIONS;
    public static final DataKey<Collection<Extension>> LOAD_EXTENSIONS = TestUtils.LOAD_EXTENSIONS;
    public static final DataKey<Collection<Extension>> EXTENSIONS = SharedDataKeys.EXTENSIONS;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    public void addSpecExample(SpecExampleRenderer exampleRenderer, SpecExampleParse exampleParse, DataHolder exampleOptions) {
    }

    @Override
    public void addFullSpecExample(@NotNull SpecExampleRenderer exampleRenderer, @NotNull SpecExampleParse exampleParse, DataHolder exampleOptions, boolean ignoredTestCase, @NotNull String html, @Nullable String ast) {
    }

    protected final void assertRendering(@NotNull String source, @NotNull String html) {
        this.assertRendering(SpecExample.ofCaller(1, this.getClass(), source, html, null));
    }

    protected final void assertRendering(@NotNull String source, @NotNull String html, @Nullable String ast) {
        this.assertRendering(SpecExample.ofCaller(1, this.getClass(), source, html, ast));
    }

    protected final void assertRendering(@NotNull SpecExample specExample) {
        String actual;
        Object expected;
        SpecExample example = this.checkExample(specExample);
        String message = example.getFileUrlWithLineNumber();
        String source = example.getSource();
        String optionsSet = example.getOptionsSet();
        String expectedHtml = example.getHtml();
        String expectedAst = example.getAst();
        DataHolder exampleOptions = TestUtils.getOptions(example, optionsSet, this::options);
        SpecExampleRenderer exampleRenderer = this.getSpecExampleRenderer(example, exampleOptions);
        SpecExampleParse specExampleParse = new SpecExampleParse(exampleRenderer.getOptions(), exampleRenderer, exampleOptions, source);
        boolean timed = specExampleParse.isTimed();
        int iterations = specExampleParse.getIterations();
        String html = exampleRenderer.getHtml();
        for (int i = 1; i < iterations; ++i) {
            exampleRenderer.getHtml();
        }
        long render = System.nanoTime();
        String ast = expectedAst == null ? null : exampleRenderer.getAst();
        boolean embedTimed = (Boolean)TestUtils.EMBED_TIMED.get(exampleRenderer.getOptions());
        String formattedTimingInfo = TestUtils.getFormattedTimingInfo(iterations, specExampleParse.getStartTime(), specExampleParse.getParseTime(), render);
        if (timed || embedTimed) {
            System.out.print(formattedTimingInfo);
        }
        this.addSpecExample(exampleRenderer, specExampleParse, exampleOptions);
        exampleRenderer.finalizeRender();
        if (example.getSection() != null) {
            StringBuilder outExpected = new StringBuilder();
            if (embedTimed) {
                outExpected.append(formattedTimingInfo);
            }
            TestUtils.addSpecExample(true, outExpected, source, expectedHtml, expectedAst, optionsSet, true, example.getSection(), example.getExampleNumber());
            expected = outExpected.toString();
            StringBuilder outActual = new StringBuilder();
            TestUtils.addSpecExample(true, outActual, source, html, ast, optionsSet, true, example.getSection(), example.getExampleNumber());
            actual = outActual.toString();
        } else {
            expected = embedTimed ? formattedTimingInfo + TestUtils.addSpecExample(true, source, expectedHtml, expectedAst, optionsSet) : TestUtils.addSpecExample(true, source, expectedHtml, ast, optionsSet);
            actual = TestUtils.addSpecExample(true, source, html, ast, optionsSet);
        }
        if (exampleOptions != null && ((Boolean)TestUtils.FAIL.get(exampleOptions)).booleanValue()) {
            this.thrown.expect(ComparisonFailure.class);
        }
        if (!message.isEmpty()) {
            Assert.assertEquals((String)message, (Object)expected, (Object)actual);
        } else {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }
}

