/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test.util;

import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.DataKeyAggregator;
import com.vladsch.flexmark.util.data.DataKeyBase;
import com.vladsch.flexmark.util.data.DataSet;
import com.vladsch.flexmark.util.data.SharedDataKeys;
import com.vladsch.flexmark.util.misc.Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadUnloadDataKeyAggregator
implements DataKeyAggregator {
    public static final DataKey<Collection<Class<? extends Extension>>> UNLOAD_EXTENSIONS = new DataKey("UNLOAD_EXTENSIONS", Collections.emptyList());
    public static final DataKey<Collection<Extension>> LOAD_EXTENSIONS = new DataKey("LOAD_EXTENSIONS", (Object)Extension.EMPTY_LIST);
    private static final LoadUnloadDataKeyAggregator INSTANCE = new LoadUnloadDataKeyAggregator();

    private LoadUnloadDataKeyAggregator() {
    }

    @NotNull
    public DataHolder aggregate(@NotNull DataHolder combined) {
        if (combined.contains(LOAD_EXTENSIONS) || combined.contains(UNLOAD_EXTENSIONS)) {
            if (combined.contains((DataKeyBase)SharedDataKeys.EXTENSIONS) || combined.contains(LOAD_EXTENSIONS)) {
                Collection extensions = (Collection)SharedDataKeys.EXTENSIONS.get(combined);
                Collection loadExtensions = (Collection)LOAD_EXTENSIONS.get(combined);
                Collection unloadExtensions = (Collection)UNLOAD_EXTENSIONS.get(combined);
                if (!loadExtensions.isEmpty() || !unloadExtensions.isEmpty() && !extensions.isEmpty()) {
                    LinkedHashSet<Extension> resolvedExtensions = new LinkedHashSet<Extension>(extensions);
                    resolvedExtensions.addAll(loadExtensions);
                    resolvedExtensions.removeIf(extension -> unloadExtensions.contains(extension.getClass()));
                    return combined.toMutable().remove(LOAD_EXTENSIONS).remove(UNLOAD_EXTENSIONS).set(SharedDataKeys.EXTENSIONS, new ArrayList(resolvedExtensions)).toImmutable();
                }
            }
            return combined.toMutable().remove(LOAD_EXTENSIONS).remove(UNLOAD_EXTENSIONS);
        }
        return combined;
    }

    @NotNull
    public DataHolder aggregateActions(@NotNull DataHolder combined, @NotNull DataHolder other, @NotNull DataHolder overrides) {
        ArrayList loadExtensions;
        if (other.contains(LOAD_EXTENSIONS) && overrides.contains(LOAD_EXTENSIONS)) {
            loadExtensions = new ArrayList((Collection)LOAD_EXTENSIONS.get(other));
            loadExtensions.addAll((Collection)LOAD_EXTENSIONS.get(overrides));
            combined = combined.toMutable().set(LOAD_EXTENSIONS, loadExtensions);
        }
        if (other.contains(UNLOAD_EXTENSIONS) && overrides.contains(UNLOAD_EXTENSIONS)) {
            loadExtensions = new ArrayList((Collection)UNLOAD_EXTENSIONS.get(other));
            loadExtensions.addAll((Collection)UNLOAD_EXTENSIONS.get(overrides));
            combined = combined.toMutable().set(UNLOAD_EXTENSIONS, loadExtensions);
        }
        return combined;
    }

    @NotNull
    public DataHolder clean(DataHolder combined) {
        if (combined.contains(LOAD_EXTENSIONS) || combined.contains(UNLOAD_EXTENSIONS)) {
            return combined.toMutable().remove(LOAD_EXTENSIONS).remove(UNLOAD_EXTENSIONS);
        }
        return combined;
    }

    @Nullable
    public Set<Class<?>> invokeAfterSet() {
        return null;
    }

    static {
        DataSet.registerDataKeyAggregator((DataKeyAggregator)INSTANCE);
    }
}

