/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test.util;

import com.vladsch.flexmark.test.util.SpecExampleParse;
import com.vladsch.flexmark.test.util.SpecExampleProcessor;
import com.vladsch.flexmark.test.util.SpecExampleRenderer;
import com.vladsch.flexmark.test.util.TestUtils;
import com.vladsch.flexmark.test.util.spec.ResourceLocation;
import com.vladsch.flexmark.test.util.spec.SpecExample;
import com.vladsch.flexmark.test.util.spec.SpecReader;
import com.vladsch.flexmark.util.data.DataHolder;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.junit.AssumptionViolatedException;

public class DumpSpecReader
extends SpecReader {
    protected final StringBuilder sb = new StringBuilder();
    protected final StringBuilder sbExp = new StringBuilder();
    protected final SpecExampleProcessor testCase;
    protected StringBuilder exampleComment;

    public DumpSpecReader(@NotNull InputStream stream, @NotNull SpecExampleProcessor testCase, @NotNull ResourceLocation location, boolean compoundSections) {
        super(stream, location, compoundSections);
        this.testCase = testCase;
    }

    public String getFullSpec() {
        return this.sb.toString();
    }

    public String getExpectedFullSpec() {
        return this.sbExp.toString();
    }

    @Override
    public void readExamples() {
        super.readExamples();
    }

    @Override
    public void addSpecLine(String line, boolean isSpecExampleOpen) {
        if (!isSpecExampleOpen) {
            this.sb.append(line).append("\n");
        }
        this.sbExp.append(line).append("\n");
    }

    @Override
    protected void addSpecExample(@NotNull SpecExample specExample) {
        String html;
        DataHolder exampleOptions;
        super.addSpecExample(specExample);
        SpecExample example = this.testCase.checkExample(specExample);
        boolean ignoredTestCase = false;
        try {
            exampleOptions = TestUtils.getOptions(example, example.getOptionsSet(), this.testCase::options);
        }
        catch (AssumptionViolatedException ignored) {
            ignoredTestCase = true;
            exampleOptions = null;
        }
        if (exampleOptions != null && ((Boolean)TestUtils.FAIL.get(exampleOptions)).booleanValue()) {
            ignoredTestCase = true;
        }
        SpecExampleRenderer exampleRenderer = this.testCase.getSpecExampleRenderer(example, exampleOptions);
        SpecExampleParse exampleParse = new SpecExampleParse(exampleRenderer.getOptions(), exampleRenderer, exampleOptions, example.getSource());
        String source = exampleParse.getSource();
        boolean timed = exampleParse.isTimed();
        int iterations = exampleParse.getIterations();
        long start = exampleParse.getStartTime();
        long parse = exampleParse.getParseTime();
        if (!ignoredTestCase) {
            html = exampleRenderer.getHtml();
            for (int i = 1; i < iterations; ++i) {
                exampleRenderer.getHtml();
            }
        } else {
            html = example.getHtml();
        }
        long render = System.nanoTime();
        boolean embedTimed = (Boolean)TestUtils.EMBED_TIMED.get(exampleRenderer.getOptions());
        String timingInfo = TestUtils.getFormattedTimingInfo(example.getSection(), example.getExampleNumber(), iterations, start, parse, render);
        if (timed || embedTimed) {
            System.out.println(timingInfo);
        }
        String ast = example.getAst() == null ? null : (!ignoredTestCase ? exampleRenderer.getAst() : example.getAst());
        this.testCase.addFullSpecExample(exampleRenderer, exampleParse, exampleOptions, ignoredTestCase, html, ast);
        exampleRenderer.finalizeRender();
        if (embedTimed) {
            this.sb.append(timingInfo);
        }
        TestUtils.addSpecExample(true, this.sb, source, html, ast, example.getOptionsSet(), exampleRenderer.includeExampleInfo(), example.getSection(), example.getExampleNumber());
        TestUtils.addSpecExample(false, this.sbExp, source, example.getHtml(), example.getAst(), example.getOptionsSet(), exampleRenderer.includeExampleInfo(), example.getSection(), example.getExampleNumber());
    }
}

