/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.tasklist;

import com.vladsch.flexmark.ext.gfm.tasklist.TaskListItemCase;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListItemPlacement;
import com.vladsch.flexmark.ext.gfm.tasklist.internal.TaskListItemBlockPreProcessor;
import com.vladsch.flexmark.ext.gfm.tasklist.internal.TaskListNodeFormatter;
import com.vladsch.flexmark.ext.gfm.tasklist.internal.TaskListNodeRenderer;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TaskListExtension
implements Parser.ParserExtension,
HtmlRenderer.HtmlRendererExtension,
Formatter.FormatterExtension {
    public static final Map<Character, Integer> DEFAULT_PRIORITIES = new HashMap<Character, Integer>();
    public static final DataKey<String> ITEM_DONE_MARKER;
    public static final DataKey<String> ITEM_NOT_DONE_MARKER;
    public static final DataKey<String> TIGHT_ITEM_CLASS;
    public static final DataKey<String> LOOSE_ITEM_CLASS;
    public static final DataKey<String> PARAGRAPH_CLASS;
    public static final DataKey<String> ITEM_DONE_CLASS;
    public static final DataKey<String> ITEM_NOT_DONE_CLASS;
    public static final DataKey<TaskListItemCase> FORMAT_LIST_ITEM_CASE;
    public static final DataKey<TaskListItemPlacement> FORMAT_LIST_ITEM_PLACEMENT;
    public static final DataKey<Integer> FORMAT_ORDERED_TASK_ITEM_PRIORITY;
    public static final DataKey<Integer> FORMAT_DEFAULT_TASK_ITEM_PRIORITY;
    public static final DataKey<Boolean> FORMAT_PRIORITIZED_TASK_ITEMS;
    public static final DataKey<Map<Character, Integer>> FORMAT_TASK_ITEM_PRIORITIES;

    private TaskListExtension() {
    }

    public static TaskListExtension create() {
        return new TaskListExtension();
    }

    @Override
    public void extend(Formatter.Builder formatterBuilder) {
        formatterBuilder.nodeFormatterFactory(TaskListNodeFormatter::new);
    }

    @Override
    public void rendererOptions(@NotNull MutableDataHolder options) {
    }

    @Override
    public void parserOptions(MutableDataHolder options) {
        ListOptions.addItemMarkerSuffixes(options, "[ ]", "[x]", "[X]");
    }

    @Override
    public void extend(Parser.Builder parserBuilder) {
        parserBuilder.blockPreProcessorFactory(new TaskListItemBlockPreProcessor.Factory());
    }

    @Override
    public void extend(@NotNull HtmlRenderer.Builder htmlRendererBuilder, @NotNull String rendererType) {
        if (htmlRendererBuilder.isRendererType("HTML")) {
            htmlRendererBuilder.nodeRendererFactory(new TaskListNodeRenderer.Factory());
        } else if (htmlRendererBuilder.isRendererType("JIRA")) {
            // empty if block
        }
    }

    static {
        DEFAULT_PRIORITIES.put(Character.valueOf('+'), 1);
        DEFAULT_PRIORITIES.put(Character.valueOf('*'), 0);
        DEFAULT_PRIORITIES.put(Character.valueOf('-'), -1);
        ITEM_DONE_MARKER = new DataKey<String>("ITEM_DONE_MARKER", "<input type=\"checkbox\" class=\"task-list-item-checkbox\" checked=\"checked\" disabled=\"disabled\" readonly=\"readonly\" />&nbsp;");
        ITEM_NOT_DONE_MARKER = new DataKey<String>("ITEM_NOT_DONE_MARKER", "<input type=\"checkbox\" class=\"task-list-item-checkbox\" disabled=\"disabled\" readonly=\"readonly\" />&nbsp;");
        TIGHT_ITEM_CLASS = new DataKey<String>("TIGHT_ITEM_CLASS", "task-list-item");
        LOOSE_ITEM_CLASS = new DataKey<DataKey<String>>("LOOSE_ITEM_CLASS", TIGHT_ITEM_CLASS);
        PARAGRAPH_CLASS = new DataKey<String>("PARAGRAPH_CLASS", "");
        ITEM_DONE_CLASS = new DataKey<String>("ITEM_DONE_CLASS", "");
        ITEM_NOT_DONE_CLASS = new DataKey<String>("ITEM_NOT_DONE_CLASS", "");
        FORMAT_LIST_ITEM_CASE = new DataKey<TaskListItemCase>("FORMAT_LIST_ITEM_CASE", TaskListItemCase.AS_IS);
        FORMAT_LIST_ITEM_PLACEMENT = new DataKey<TaskListItemPlacement>("FORMAT_LIST_ITEM_PLACEMENT", TaskListItemPlacement.AS_IS);
        FORMAT_ORDERED_TASK_ITEM_PRIORITY = new DataKey<Integer>("FORMAT_ORDERED_TASK_ITEM_PRIORITY", 0);
        FORMAT_DEFAULT_TASK_ITEM_PRIORITY = new DataKey<Integer>("FORMAT_DEFAULT_TASK_ITEM_PRIORITY", 0);
        FORMAT_PRIORITIZED_TASK_ITEMS = new DataKey<Boolean>("FORMAT_PRIORITIZED_TASK_ITEMS", false);
        FORMAT_TASK_ITEM_PRIORITIES = new DataKey<Map<Character, Integer>>("FORMAT_TASK_ITEM_PRIORITIES", DEFAULT_PRIORITIES);
    }
}

