/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.spec.example;

import com.vladsch.flexmark.ext.spec.example.internal.RenderAs;
import com.vladsch.flexmark.ext.spec.example.internal.SpecExampleBlockParser;
import com.vladsch.flexmark.ext.spec.example.internal.SpecExampleNodeFormatter;
import com.vladsch.flexmark.ext.spec.example.internal.SpecExampleNodeRenderer;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SpecExampleExtension
implements Parser.ParserExtension,
HtmlRenderer.HtmlRendererExtension,
Formatter.FormatterExtension {
    private static final Map<Integer, String> DEFAULT_LANGUAGE_MAPPING = new HashMap<Integer, String>();
    private static final Map<Integer, String> DEFAULT_SECTION_MAPPING;
    public static final DataKey<Boolean> SPEC_EXAMPLE_RENDER_RAW_HTML;
    public static final DataKey<String> SPEC_EXAMPLE_RENDERED_HTML_PREFIX;
    public static final DataKey<String> SPEC_EXAMPLE_RENDERED_HTML_SUFFIX;
    public static final DataKey<RenderAs> SPEC_EXAMPLE_RENDER_AS;
    public static final DataKey<String> SPEC_EXAMPLE_BREAK;
    public static final DataKey<String> SPEC_SECTION_BREAK;
    public static final DataKey<Boolean> SPEC_OPTION_NODES;
    public static final DataKey<Map<Integer, String>> SPEC_EXAMPLE_SECTION_LANGUAGES;
    public static final DataKey<Map<Integer, String>> SPEC_EXAMPLE_SECTION_NAMES;
    @Deprecated
    public static final DataKey<String> SPEC_TYPE_BREAK;

    private SpecExampleExtension() {
    }

    public static SpecExampleExtension create() {
        return new SpecExampleExtension();
    }

    public void rendererOptions(@NotNull MutableDataHolder options) {
    }

    public void parserOptions(MutableDataHolder options) {
    }

    public void extend(Formatter.Builder formatterBuilder) {
        formatterBuilder.nodeFormatterFactory((NodeFormatterFactory)new SpecExampleNodeFormatter.Factory());
    }

    public void extend(Parser.Builder parserBuilder) {
        parserBuilder.customBlockParserFactory((CustomBlockParserFactory)new SpecExampleBlockParser.Factory());
    }

    public void extend(@NotNull HtmlRenderer.Builder htmlRendererBuilder, @NotNull String rendererType) {
        if (htmlRendererBuilder.isRendererType("HTML")) {
            htmlRendererBuilder.nodeRendererFactory((NodeRendererFactory)new SpecExampleNodeRenderer.Factory());
        } else if (htmlRendererBuilder.isRendererType("JIRA")) {
            // empty if block
        }
    }

    static {
        DEFAULT_LANGUAGE_MAPPING.put(1, "markdown");
        DEFAULT_LANGUAGE_MAPPING.put(2, "html");
        DEFAULT_LANGUAGE_MAPPING.put(3, "text");
        DEFAULT_SECTION_MAPPING = new HashMap<Integer, String>();
        DEFAULT_SECTION_MAPPING.put(1, "Source");
        DEFAULT_SECTION_MAPPING.put(2, "Html");
        DEFAULT_SECTION_MAPPING.put(3, "AST");
        SPEC_EXAMPLE_RENDER_RAW_HTML = new DataKey("SPEC_EXAMPLE_RENDER_RAW_HTML", (Object)true);
        SPEC_EXAMPLE_RENDERED_HTML_PREFIX = new DataKey("SPEC_EXAMPLE_RENDERED_HTML_PREFIX", (Object)"<div style=\"border:solid #cccccc 1px;padding:0 20px 10px 20px;\">");
        SPEC_EXAMPLE_RENDERED_HTML_SUFFIX = new DataKey("SPEC_EXAMPLE_RENDERED_HTML_SUFFIX", (Object)"</div>");
        SPEC_EXAMPLE_RENDER_AS = new DataKey("SPEC_EXAMPLE_RENDER_AS", (Object)RenderAs.FENCED_CODE);
        SPEC_EXAMPLE_BREAK = new DataKey("SPEC_EXAMPLE_BREAK", (Object)"````````````````````````````````");
        SPEC_SECTION_BREAK = new DataKey("SPEC_SECTION_BREAK", (Object)".");
        SPEC_OPTION_NODES = new DataKey("SPEC_OPTION_NODES", (Object)true);
        SPEC_EXAMPLE_SECTION_LANGUAGES = new DataKey("SPEC_EXAMPLE_SECTION_LANGUAGES", DEFAULT_LANGUAGE_MAPPING);
        SPEC_EXAMPLE_SECTION_NAMES = new DataKey("SPEC_EXAMPLE_SECTION_NAMES", DEFAULT_SECTION_MAPPING);
        SPEC_TYPE_BREAK = SPEC_SECTION_BREAK;
    }
}

