/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.macros;

import com.vladsch.flexmark.ast.CustomNode;
import com.vladsch.flexmark.ast.DelimitedNode;
import com.vladsch.flexmark.ast.DoNotDecorate;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.ReferencingNode;
import com.vladsch.flexmark.ext.macros.MacroDefinitionBlock;
import com.vladsch.flexmark.ext.macros.MacrosExtension;
import com.vladsch.flexmark.ext.macros.internal.MacroDefinitionRepository;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class MacroReference
extends CustomNode
implements DelimitedNode,
DoNotDecorate,
ReferencingNode<MacroDefinitionRepository, MacroDefinitionBlock> {
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence text = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;
    protected MacroDefinitionBlock myMacroDefinitionBlock;

    public boolean isDefined() {
        return this.myMacroDefinitionBlock != null;
    }

    public BasedSequence getReference() {
        return this.text;
    }

    public MacroDefinitionBlock getReferenceNode(Document document) {
        if (this.myMacroDefinitionBlock != null || this.text.isEmpty()) {
            return this.myMacroDefinitionBlock;
        }
        this.myMacroDefinitionBlock = this.getMacroDefinitionBlock((MacroDefinitionRepository)((Object)document.get(MacrosExtension.MACRO_DEFINITIONS)));
        return this.myMacroDefinitionBlock;
    }

    public MacroDefinitionBlock getReferenceNode(MacroDefinitionRepository repository) {
        if (this.myMacroDefinitionBlock != null || this.text.isEmpty()) {
            return this.myMacroDefinitionBlock;
        }
        this.myMacroDefinitionBlock = this.getMacroDefinitionBlock(repository);
        return this.myMacroDefinitionBlock;
    }

    public MacroDefinitionBlock getMacroDefinitionBlock(MacroDefinitionRepository repository) {
        return this.text.isEmpty() ? null : (MacroDefinitionBlock)((Object)repository.get(this.text.toString()));
    }

    public MacroDefinitionBlock getMacroDefinitionBlock() {
        return this.myMacroDefinitionBlock;
    }

    public void setMacroDefinitionBlock(MacroDefinitionBlock macroDefinitionBlock) {
        this.myMacroDefinitionBlock = macroDefinitionBlock;
    }

    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.text, this.closingMarker};
    }

    public void getAstExtra(StringBuilder out) {
        MacroReference.delimitedSegmentSpanChars((StringBuilder)out, (BasedSequence)this.openingMarker, (BasedSequence)this.text, (BasedSequence)this.closingMarker, (String)"text");
    }

    public MacroReference() {
    }

    public MacroReference(BasedSequence chars) {
        super(chars);
    }

    public MacroReference(BasedSequence openingMarker, BasedSequence text, BasedSequence closingMarker) {
        super(openingMarker.baseSubSequence(openingMarker.getStartOffset(), closingMarker.getEndOffset()));
        this.openingMarker = openingMarker;
        this.text = text;
        this.closingMarker = closingMarker;
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    public BasedSequence getText() {
        return this.text;
    }

    public void setText(BasedSequence text) {
        this.text = text;
    }

    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker;
    }
}

